/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 6.0.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGGLSpectrum.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGGLSpectrum::SWGGLSpectrum(QString* json) {
    init();
    this->fromJson(*json);
}

SWGGLSpectrum::SWGGLSpectrum() {
    fft_size = 0;
    m_fft_size_isSet = false;
    fft_overlap = 0;
    m_fft_overlap_isSet = false;
    fft_window = 0;
    m_fft_window_isSet = false;
    ref_level = 0.0f;
    m_ref_level_isSet = false;
    power_range = 0.0f;
    m_power_range_isSet = false;
    fps_period_ms = 0;
    m_fps_period_ms_isSet = false;
    display_waterfall = 0;
    m_display_waterfall_isSet = false;
    inverted_waterfall = 0;
    m_inverted_waterfall_isSet = false;
    display_max_hold = 0;
    m_display_max_hold_isSet = false;
    display_histogram = 0;
    m_display_histogram_isSet = false;
    decay = 0;
    m_decay_isSet = false;
    display_grid = 0;
    m_display_grid_isSet = false;
    display_grid_intensity = 0;
    m_display_grid_intensity_isSet = false;
    decay_divisor = 0;
    m_decay_divisor_isSet = false;
    histogram_stroke = 0;
    m_histogram_stroke_isSet = false;
    display_current = 0;
    m_display_current_isSet = false;
    display_trace_intensity = 0;
    m_display_trace_intensity_isSet = false;
    waterfall_share = 0.0f;
    m_waterfall_share_isSet = false;
    averaging_mode = 0;
    m_averaging_mode_isSet = false;
    averaging_value = 0;
    m_averaging_value_isSet = false;
    linear = 0;
    m_linear_isSet = false;
    ssb = 0;
    m_ssb_isSet = false;
    usb = 0;
    m_usb_isSet = false;
    ws_spectrum_address = nullptr;
    m_ws_spectrum_address_isSet = false;
    ws_spectrum_port = 0;
    m_ws_spectrum_port_isSet = false;
}

SWGGLSpectrum::~SWGGLSpectrum() {
    this->cleanup();
}

void
SWGGLSpectrum::init() {
    fft_size = 0;
    m_fft_size_isSet = false;
    fft_overlap = 0;
    m_fft_overlap_isSet = false;
    fft_window = 0;
    m_fft_window_isSet = false;
    ref_level = 0.0f;
    m_ref_level_isSet = false;
    power_range = 0.0f;
    m_power_range_isSet = false;
    fps_period_ms = 0;
    m_fps_period_ms_isSet = false;
    display_waterfall = 0;
    m_display_waterfall_isSet = false;
    inverted_waterfall = 0;
    m_inverted_waterfall_isSet = false;
    display_max_hold = 0;
    m_display_max_hold_isSet = false;
    display_histogram = 0;
    m_display_histogram_isSet = false;
    decay = 0;
    m_decay_isSet = false;
    display_grid = 0;
    m_display_grid_isSet = false;
    display_grid_intensity = 0;
    m_display_grid_intensity_isSet = false;
    decay_divisor = 0;
    m_decay_divisor_isSet = false;
    histogram_stroke = 0;
    m_histogram_stroke_isSet = false;
    display_current = 0;
    m_display_current_isSet = false;
    display_trace_intensity = 0;
    m_display_trace_intensity_isSet = false;
    waterfall_share = 0.0f;
    m_waterfall_share_isSet = false;
    averaging_mode = 0;
    m_averaging_mode_isSet = false;
    averaging_value = 0;
    m_averaging_value_isSet = false;
    linear = 0;
    m_linear_isSet = false;
    ssb = 0;
    m_ssb_isSet = false;
    usb = 0;
    m_usb_isSet = false;
    ws_spectrum_address = new QString("");
    m_ws_spectrum_address_isSet = false;
    ws_spectrum_port = 0;
    m_ws_spectrum_port_isSet = false;
}

void
SWGGLSpectrum::cleanup() {























    if(ws_spectrum_address != nullptr) { 
        delete ws_spectrum_address;
    }

}

SWGGLSpectrum*
SWGGLSpectrum::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGGLSpectrum::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&fft_size, pJson["fftSize"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fft_overlap, pJson["fftOverlap"], "qint32", "");
    
    ::SWGSDRangel::setValue(&fft_window, pJson["fftWindow"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ref_level, pJson["refLevel"], "float", "");
    
    ::SWGSDRangel::setValue(&power_range, pJson["powerRange"], "float", "");
    
    ::SWGSDRangel::setValue(&fps_period_ms, pJson["fpsPeriodMs"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_waterfall, pJson["displayWaterfall"], "qint32", "");
    
    ::SWGSDRangel::setValue(&inverted_waterfall, pJson["invertedWaterfall"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_max_hold, pJson["displayMaxHold"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_histogram, pJson["displayHistogram"], "qint32", "");
    
    ::SWGSDRangel::setValue(&decay, pJson["decay"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_grid, pJson["displayGrid"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_grid_intensity, pJson["displayGridIntensity"], "qint32", "");
    
    ::SWGSDRangel::setValue(&decay_divisor, pJson["decayDivisor"], "qint32", "");
    
    ::SWGSDRangel::setValue(&histogram_stroke, pJson["histogramStroke"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_current, pJson["displayCurrent"], "qint32", "");
    
    ::SWGSDRangel::setValue(&display_trace_intensity, pJson["displayTraceIntensity"], "qint32", "");
    
    ::SWGSDRangel::setValue(&waterfall_share, pJson["waterfallShare"], "float", "");
    
    ::SWGSDRangel::setValue(&averaging_mode, pJson["averagingMode"], "qint32", "");
    
    ::SWGSDRangel::setValue(&averaging_value, pJson["averagingValue"], "qint32", "");
    
    ::SWGSDRangel::setValue(&linear, pJson["linear"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ssb, pJson["ssb"], "qint32", "");
    
    ::SWGSDRangel::setValue(&usb, pJson["usb"], "qint32", "");
    
    ::SWGSDRangel::setValue(&ws_spectrum_address, pJson["wsSpectrumAddress"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&ws_spectrum_port, pJson["wsSpectrumPort"], "qint32", "");
    
}

QString
SWGGLSpectrum::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGGLSpectrum::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(m_fft_size_isSet){
        obj->insert("fftSize", QJsonValue(fft_size));
    }
    if(m_fft_overlap_isSet){
        obj->insert("fftOverlap", QJsonValue(fft_overlap));
    }
    if(m_fft_window_isSet){
        obj->insert("fftWindow", QJsonValue(fft_window));
    }
    if(m_ref_level_isSet){
        obj->insert("refLevel", QJsonValue(ref_level));
    }
    if(m_power_range_isSet){
        obj->insert("powerRange", QJsonValue(power_range));
    }
    if(m_fps_period_ms_isSet){
        obj->insert("fpsPeriodMs", QJsonValue(fps_period_ms));
    }
    if(m_display_waterfall_isSet){
        obj->insert("displayWaterfall", QJsonValue(display_waterfall));
    }
    if(m_inverted_waterfall_isSet){
        obj->insert("invertedWaterfall", QJsonValue(inverted_waterfall));
    }
    if(m_display_max_hold_isSet){
        obj->insert("displayMaxHold", QJsonValue(display_max_hold));
    }
    if(m_display_histogram_isSet){
        obj->insert("displayHistogram", QJsonValue(display_histogram));
    }
    if(m_decay_isSet){
        obj->insert("decay", QJsonValue(decay));
    }
    if(m_display_grid_isSet){
        obj->insert("displayGrid", QJsonValue(display_grid));
    }
    if(m_display_grid_intensity_isSet){
        obj->insert("displayGridIntensity", QJsonValue(display_grid_intensity));
    }
    if(m_decay_divisor_isSet){
        obj->insert("decayDivisor", QJsonValue(decay_divisor));
    }
    if(m_histogram_stroke_isSet){
        obj->insert("histogramStroke", QJsonValue(histogram_stroke));
    }
    if(m_display_current_isSet){
        obj->insert("displayCurrent", QJsonValue(display_current));
    }
    if(m_display_trace_intensity_isSet){
        obj->insert("displayTraceIntensity", QJsonValue(display_trace_intensity));
    }
    if(m_waterfall_share_isSet){
        obj->insert("waterfallShare", QJsonValue(waterfall_share));
    }
    if(m_averaging_mode_isSet){
        obj->insert("averagingMode", QJsonValue(averaging_mode));
    }
    if(m_averaging_value_isSet){
        obj->insert("averagingValue", QJsonValue(averaging_value));
    }
    if(m_linear_isSet){
        obj->insert("linear", QJsonValue(linear));
    }
    if(m_ssb_isSet){
        obj->insert("ssb", QJsonValue(ssb));
    }
    if(m_usb_isSet){
        obj->insert("usb", QJsonValue(usb));
    }
    if(ws_spectrum_address != nullptr && *ws_spectrum_address != QString("")){
        toJsonValue(QString("wsSpectrumAddress"), ws_spectrum_address, obj, QString("QString"));
    }
    if(m_ws_spectrum_port_isSet){
        obj->insert("wsSpectrumPort", QJsonValue(ws_spectrum_port));
    }

    return obj;
}

qint32
SWGGLSpectrum::getFftSize() {
    return fft_size;
}
void
SWGGLSpectrum::setFftSize(qint32 fft_size) {
    this->fft_size = fft_size;
    this->m_fft_size_isSet = true;
}

qint32
SWGGLSpectrum::getFftOverlap() {
    return fft_overlap;
}
void
SWGGLSpectrum::setFftOverlap(qint32 fft_overlap) {
    this->fft_overlap = fft_overlap;
    this->m_fft_overlap_isSet = true;
}

qint32
SWGGLSpectrum::getFftWindow() {
    return fft_window;
}
void
SWGGLSpectrum::setFftWindow(qint32 fft_window) {
    this->fft_window = fft_window;
    this->m_fft_window_isSet = true;
}

float
SWGGLSpectrum::getRefLevel() {
    return ref_level;
}
void
SWGGLSpectrum::setRefLevel(float ref_level) {
    this->ref_level = ref_level;
    this->m_ref_level_isSet = true;
}

float
SWGGLSpectrum::getPowerRange() {
    return power_range;
}
void
SWGGLSpectrum::setPowerRange(float power_range) {
    this->power_range = power_range;
    this->m_power_range_isSet = true;
}

qint32
SWGGLSpectrum::getFpsPeriodMs() {
    return fps_period_ms;
}
void
SWGGLSpectrum::setFpsPeriodMs(qint32 fps_period_ms) {
    this->fps_period_ms = fps_period_ms;
    this->m_fps_period_ms_isSet = true;
}

qint32
SWGGLSpectrum::getDisplayWaterfall() {
    return display_waterfall;
}
void
SWGGLSpectrum::setDisplayWaterfall(qint32 display_waterfall) {
    this->display_waterfall = display_waterfall;
    this->m_display_waterfall_isSet = true;
}

qint32
SWGGLSpectrum::getInvertedWaterfall() {
    return inverted_waterfall;
}
void
SWGGLSpectrum::setInvertedWaterfall(qint32 inverted_waterfall) {
    this->inverted_waterfall = inverted_waterfall;
    this->m_inverted_waterfall_isSet = true;
}

qint32
SWGGLSpectrum::getDisplayMaxHold() {
    return display_max_hold;
}
void
SWGGLSpectrum::setDisplayMaxHold(qint32 display_max_hold) {
    this->display_max_hold = display_max_hold;
    this->m_display_max_hold_isSet = true;
}

qint32
SWGGLSpectrum::getDisplayHistogram() {
    return display_histogram;
}
void
SWGGLSpectrum::setDisplayHistogram(qint32 display_histogram) {
    this->display_histogram = display_histogram;
    this->m_display_histogram_isSet = true;
}

qint32
SWGGLSpectrum::getDecay() {
    return decay;
}
void
SWGGLSpectrum::setDecay(qint32 decay) {
    this->decay = decay;
    this->m_decay_isSet = true;
}

qint32
SWGGLSpectrum::getDisplayGrid() {
    return display_grid;
}
void
SWGGLSpectrum::setDisplayGrid(qint32 display_grid) {
    this->display_grid = display_grid;
    this->m_display_grid_isSet = true;
}

qint32
SWGGLSpectrum::getDisplayGridIntensity() {
    return display_grid_intensity;
}
void
SWGGLSpectrum::setDisplayGridIntensity(qint32 display_grid_intensity) {
    this->display_grid_intensity = display_grid_intensity;
    this->m_display_grid_intensity_isSet = true;
}

qint32
SWGGLSpectrum::getDecayDivisor() {
    return decay_divisor;
}
void
SWGGLSpectrum::setDecayDivisor(qint32 decay_divisor) {
    this->decay_divisor = decay_divisor;
    this->m_decay_divisor_isSet = true;
}

qint32
SWGGLSpectrum::getHistogramStroke() {
    return histogram_stroke;
}
void
SWGGLSpectrum::setHistogramStroke(qint32 histogram_stroke) {
    this->histogram_stroke = histogram_stroke;
    this->m_histogram_stroke_isSet = true;
}

qint32
SWGGLSpectrum::getDisplayCurrent() {
    return display_current;
}
void
SWGGLSpectrum::setDisplayCurrent(qint32 display_current) {
    this->display_current = display_current;
    this->m_display_current_isSet = true;
}

qint32
SWGGLSpectrum::getDisplayTraceIntensity() {
    return display_trace_intensity;
}
void
SWGGLSpectrum::setDisplayTraceIntensity(qint32 display_trace_intensity) {
    this->display_trace_intensity = display_trace_intensity;
    this->m_display_trace_intensity_isSet = true;
}

float
SWGGLSpectrum::getWaterfallShare() {
    return waterfall_share;
}
void
SWGGLSpectrum::setWaterfallShare(float waterfall_share) {
    this->waterfall_share = waterfall_share;
    this->m_waterfall_share_isSet = true;
}

qint32
SWGGLSpectrum::getAveragingMode() {
    return averaging_mode;
}
void
SWGGLSpectrum::setAveragingMode(qint32 averaging_mode) {
    this->averaging_mode = averaging_mode;
    this->m_averaging_mode_isSet = true;
}

qint32
SWGGLSpectrum::getAveragingValue() {
    return averaging_value;
}
void
SWGGLSpectrum::setAveragingValue(qint32 averaging_value) {
    this->averaging_value = averaging_value;
    this->m_averaging_value_isSet = true;
}

qint32
SWGGLSpectrum::getLinear() {
    return linear;
}
void
SWGGLSpectrum::setLinear(qint32 linear) {
    this->linear = linear;
    this->m_linear_isSet = true;
}

qint32
SWGGLSpectrum::getSsb() {
    return ssb;
}
void
SWGGLSpectrum::setSsb(qint32 ssb) {
    this->ssb = ssb;
    this->m_ssb_isSet = true;
}

qint32
SWGGLSpectrum::getUsb() {
    return usb;
}
void
SWGGLSpectrum::setUsb(qint32 usb) {
    this->usb = usb;
    this->m_usb_isSet = true;
}

QString*
SWGGLSpectrum::getWsSpectrumAddress() {
    return ws_spectrum_address;
}
void
SWGGLSpectrum::setWsSpectrumAddress(QString* ws_spectrum_address) {
    this->ws_spectrum_address = ws_spectrum_address;
    this->m_ws_spectrum_address_isSet = true;
}

qint32
SWGGLSpectrum::getWsSpectrumPort() {
    return ws_spectrum_port;
}
void
SWGGLSpectrum::setWsSpectrumPort(qint32 ws_spectrum_port) {
    this->ws_spectrum_port = ws_spectrum_port;
    this->m_ws_spectrum_port_isSet = true;
}


bool
SWGGLSpectrum::isSet(){
    bool isObjectUpdated = false;
    do{
        if(m_fft_size_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fft_overlap_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fft_window_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ref_level_isSet){
            isObjectUpdated = true; break;
        }
        if(m_power_range_isSet){
            isObjectUpdated = true; break;
        }
        if(m_fps_period_ms_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_waterfall_isSet){
            isObjectUpdated = true; break;
        }
        if(m_inverted_waterfall_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_max_hold_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_histogram_isSet){
            isObjectUpdated = true; break;
        }
        if(m_decay_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_grid_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_grid_intensity_isSet){
            isObjectUpdated = true; break;
        }
        if(m_decay_divisor_isSet){
            isObjectUpdated = true; break;
        }
        if(m_histogram_stroke_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_current_isSet){
            isObjectUpdated = true; break;
        }
        if(m_display_trace_intensity_isSet){
            isObjectUpdated = true; break;
        }
        if(m_waterfall_share_isSet){
            isObjectUpdated = true; break;
        }
        if(m_averaging_mode_isSet){
            isObjectUpdated = true; break;
        }
        if(m_averaging_value_isSet){
            isObjectUpdated = true; break;
        }
        if(m_linear_isSet){
            isObjectUpdated = true; break;
        }
        if(m_ssb_isSet){
            isObjectUpdated = true; break;
        }
        if(m_usb_isSet){
            isObjectUpdated = true; break;
        }
        if(ws_spectrum_address && *ws_spectrum_address != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_ws_spectrum_port_isSet){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

