/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.15.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGFeatureReport.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGFeatureReport::SWGFeatureReport(QString* json) {
    init();
    this->fromJson(*json);
}

SWGFeatureReport::SWGFeatureReport() {
    feature_type = nullptr;
    m_feature_type_isSet = false;
    simple_ptt_report = nullptr;
    m_simple_ptt_report_isSet = false;
}

SWGFeatureReport::~SWGFeatureReport() {
    this->cleanup();
}

void
SWGFeatureReport::init() {
    feature_type = new QString("");
    m_feature_type_isSet = false;
    simple_ptt_report = new SWGSimplePTTReport();
    m_simple_ptt_report_isSet = false;
}

void
SWGFeatureReport::cleanup() {
    if(feature_type != nullptr) { 
        delete feature_type;
    }
    if(simple_ptt_report != nullptr) { 
        delete simple_ptt_report;
    }
}

SWGFeatureReport*
SWGFeatureReport::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGFeatureReport::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&feature_type, pJson["featureType"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&simple_ptt_report, pJson["SimplePTTReport"], "SWGSimplePTTReport", "SWGSimplePTTReport");
    
}

QString
SWGFeatureReport::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGFeatureReport::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(feature_type != nullptr && *feature_type != QString("")){
        toJsonValue(QString("featureType"), feature_type, obj, QString("QString"));
    }
    if((simple_ptt_report != nullptr) && (simple_ptt_report->isSet())){
        toJsonValue(QString("SimplePTTReport"), simple_ptt_report, obj, QString("SWGSimplePTTReport"));
    }

    return obj;
}

QString*
SWGFeatureReport::getFeatureType() {
    return feature_type;
}
void
SWGFeatureReport::setFeatureType(QString* feature_type) {
    this->feature_type = feature_type;
    this->m_feature_type_isSet = true;
}

SWGSimplePTTReport*
SWGFeatureReport::getSimplePttReport() {
    return simple_ptt_report;
}
void
SWGFeatureReport::setSimplePttReport(SWGSimplePTTReport* simple_ptt_report) {
    this->simple_ptt_report = simple_ptt_report;
    this->m_simple_ptt_report_isSet = true;
}


bool
SWGFeatureReport::isSet(){
    bool isObjectUpdated = false;
    do{
        if(feature_type && *feature_type != QString("")){
            isObjectUpdated = true; break;
        }
        if(simple_ptt_report && simple_ptt_report->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

