/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.13.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

#include "SWGDevicesetApi.h"
#include "SWGHelpers.h"
#include "SWGModelFactory.h"

#include <QJsonArray>
#include <QJsonDocument>

namespace SWGSDRangel {

SWGDevicesetApi::SWGDevicesetApi() {}

SWGDevicesetApi::~SWGDevicesetApi() {}

SWGDevicesetApi::SWGDevicesetApi(QString host, QString basePath) {
    this->host = host;
    this->basePath = basePath;
}

void
SWGDevicesetApi::devicesetChannelActionsPost(qint32 device_set_index, qint32 channel_index, SWGChannelActions& body) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/deviceset/{deviceSetIndex}/channel/{channelIndex}/actions");

    QString device_set_indexPathParam("{"); device_set_indexPathParam.append("deviceSetIndex").append("}");
    fullPath.replace(device_set_indexPathParam, stringValue(device_set_index));
    QString channel_indexPathParam("{"); channel_indexPathParam.append("channelIndex").append("}");
    fullPath.replace(channel_indexPathParam, stringValue(channel_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "POST");


    
    QString output = body.asJson();
    input.request_body.append(output);
    


    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGDevicesetApi::devicesetChannelActionsPostCallback);

    worker->execute(&input);
}

void
SWGDevicesetApi::devicesetChannelActionsPostCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGSuccessResponse* output = static_cast<SWGSuccessResponse*>(create(json, QString("SWGSuccessResponse")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit devicesetChannelActionsPostSignal(output);
    } else {
        emit devicesetChannelActionsPostSignalE(output, error_type, error_str);
        emit devicesetChannelActionsPostSignalEFull(worker, error_type, error_str);
    }
}

void
SWGDevicesetApi::devicesetDeviceActionsPost(qint32 device_set_index, SWGDeviceActions& body) {
    QString fullPath;
    fullPath.append(this->host).append(this->basePath).append("/sdrangel/deviceset/{deviceSetIndex}/device/actions");

    QString device_set_indexPathParam("{"); device_set_indexPathParam.append("deviceSetIndex").append("}");
    fullPath.replace(device_set_indexPathParam, stringValue(device_set_index));


    SWGHttpRequestWorker *worker = new SWGHttpRequestWorker();
    SWGHttpRequestInput input(fullPath, "POST");


    
    QString output = body.asJson();
    input.request_body.append(output);
    


    foreach(QString key, this->defaultHeaders.keys()) {
        input.headers.insert(key, this->defaultHeaders.value(key));
    }

    connect(worker,
            &SWGHttpRequestWorker::on_execution_finished,
            this,
            &SWGDevicesetApi::devicesetDeviceActionsPostCallback);

    worker->execute(&input);
}

void
SWGDevicesetApi::devicesetDeviceActionsPostCallback(SWGHttpRequestWorker * worker) {
    QString msg;
    QString error_str = worker->error_str;
    QNetworkReply::NetworkError error_type = worker->error_type;

    if (worker->error_type == QNetworkReply::NoError) {
        msg = QString("Success! %1 bytes").arg(worker->response.length());
    }
    else {
        msg = "Error: " + worker->error_str;
    }


    QString json(worker->response);
    SWGSuccessResponse* output = static_cast<SWGSuccessResponse*>(create(json, QString("SWGSuccessResponse")));
    worker->deleteLater();

    if (worker->error_type == QNetworkReply::NoError) {
        emit devicesetDeviceActionsPostSignal(output);
    } else {
        emit devicesetDeviceActionsPostSignalE(output, error_type, error_str);
        emit devicesetDeviceActionsPostSignalEFull(worker, error_type, error_str);
    }
}


}
