/**
 * SDRangel
 * This is the web REST/JSON API of SDRangel SDR software. SDRangel is an Open Source Qt5/OpenGL 3.0+ (4.3+ in Windows) GUI and server Software Defined Radio and signal analyzer in software. It supports Airspy, BladeRF, HackRF, LimeSDR, PlutoSDR, RTL-SDR, SDRplay RSP1 and FunCube    ---   Limitations and specifcities:    * In SDRangel GUI the first Rx device set cannot be deleted. Conversely the server starts with no device sets and its number of device sets can be reduced to zero by as many calls as necessary to /sdrangel/deviceset with DELETE method.   * Preset import and export from/to file is a server only feature.   * Device set focus is a GUI only feature.   * The following channels are not implemented (status 501 is returned): ATV and DATV demodulators, Channel Analyzer NG, LoRa demodulator   * The device settings and report structures contains only the sub-structure corresponding to the device type. The DeviceSettings and DeviceReport structures documented here shows all of them but only one will be or should be present at a time   * The channel settings and report structures contains only the sub-structure corresponding to the channel type. The ChannelSettings and ChannelReport structures documented here shows all of them but only one will be or should be present at a time    --- 
 *
 * OpenAPI spec version: 4.13.0
 * Contact: f4exb06@gmail.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


#include "SWGDeviceConfig.h"

#include "SWGHelpers.h"

#include <QJsonDocument>
#include <QJsonArray>
#include <QObject>
#include <QDebug>

namespace SWGSDRangel {

SWGDeviceConfig::SWGDeviceConfig(QString* json) {
    init();
    this->fromJson(*json);
}

SWGDeviceConfig::SWGDeviceConfig() {
    device_id = nullptr;
    m_device_id_isSet = false;
    device_serial = nullptr;
    m_device_serial_isSet = false;
    device_sequence = 0;
    m_device_sequence_isSet = false;
    config = nullptr;
    m_config_isSet = false;
}

SWGDeviceConfig::~SWGDeviceConfig() {
    this->cleanup();
}

void
SWGDeviceConfig::init() {
    device_id = new QString("");
    m_device_id_isSet = false;
    device_serial = new QString("");
    m_device_serial_isSet = false;
    device_sequence = 0;
    m_device_sequence_isSet = false;
    config = new SWGDeviceSettings();
    m_config_isSet = false;
}

void
SWGDeviceConfig::cleanup() {
    if(device_id != nullptr) { 
        delete device_id;
    }
    if(device_serial != nullptr) { 
        delete device_serial;
    }

    if(config != nullptr) { 
        delete config;
    }
}

SWGDeviceConfig*
SWGDeviceConfig::fromJson(QString &json) {
    QByteArray array (json.toStdString().c_str());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
    return this;
}

void
SWGDeviceConfig::fromJsonObject(QJsonObject &pJson) {
    ::SWGSDRangel::setValue(&device_id, pJson["deviceId"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&device_serial, pJson["deviceSerial"], "QString", "QString");
    
    ::SWGSDRangel::setValue(&device_sequence, pJson["deviceSequence"], "qint32", "");
    
    ::SWGSDRangel::setValue(&config, pJson["config"], "SWGDeviceSettings", "SWGDeviceSettings");
    
}

QString
SWGDeviceConfig::asJson ()
{
    QJsonObject* obj = this->asJsonObject();

    QJsonDocument doc(*obj);
    QByteArray bytes = doc.toJson();
    delete obj;
    return QString(bytes);
}

QJsonObject*
SWGDeviceConfig::asJsonObject() {
    QJsonObject* obj = new QJsonObject();
    if(device_id != nullptr && *device_id != QString("")){
        toJsonValue(QString("deviceId"), device_id, obj, QString("QString"));
    }
    if(device_serial != nullptr && *device_serial != QString("")){
        toJsonValue(QString("deviceSerial"), device_serial, obj, QString("QString"));
    }
    if(m_device_sequence_isSet){
        obj->insert("deviceSequence", QJsonValue(device_sequence));
    }
    if((config != nullptr) && (config->isSet())){
        toJsonValue(QString("config"), config, obj, QString("SWGDeviceSettings"));
    }

    return obj;
}

QString*
SWGDeviceConfig::getDeviceId() {
    return device_id;
}
void
SWGDeviceConfig::setDeviceId(QString* device_id) {
    this->device_id = device_id;
    this->m_device_id_isSet = true;
}

QString*
SWGDeviceConfig::getDeviceSerial() {
    return device_serial;
}
void
SWGDeviceConfig::setDeviceSerial(QString* device_serial) {
    this->device_serial = device_serial;
    this->m_device_serial_isSet = true;
}

qint32
SWGDeviceConfig::getDeviceSequence() {
    return device_sequence;
}
void
SWGDeviceConfig::setDeviceSequence(qint32 device_sequence) {
    this->device_sequence = device_sequence;
    this->m_device_sequence_isSet = true;
}

SWGDeviceSettings*
SWGDeviceConfig::getConfig() {
    return config;
}
void
SWGDeviceConfig::setConfig(SWGDeviceSettings* config) {
    this->config = config;
    this->m_config_isSet = true;
}


bool
SWGDeviceConfig::isSet(){
    bool isObjectUpdated = false;
    do{
        if(device_id && *device_id != QString("")){
            isObjectUpdated = true; break;
        }
        if(device_serial && *device_serial != QString("")){
            isObjectUpdated = true; break;
        }
        if(m_device_sequence_isSet){
            isObjectUpdated = true; break;
        }
        if(config && config->isSet()){
            isObjectUpdated = true; break;
        }
    }while(false);
    return isObjectUpdated;
}
}

