% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionaries.R
\name{zstd_dict_id}
\alias{zstd_dict_id}
\title{Get the Dictionary ID of a dictionary or a vector compressed data.}
\usage{
zstd_dict_id(dict)
}
\arguments{
\item{dict}{raw vector or filename.  This object could contain either a 
zstd dictionary, or a compressed object.  If it is a compressed object,
then it will return the dictionary id which was used to compress it.}
}
\value{
Signed integer value representing the Dictionary ID. If data does not 
        represent a dictionary, or data which was compressed with a dictionary,
        then a value of 0 is returned.
}
\description{
Dictionary IDs are generated automatically when a dictionary is created.
When using a dictionary for compression, the same dictionary must be used
during decompression.  ZSTD internally does this check for matching IDs
when attempting to decompress.  This function exposes the dictionary ID
to aid in handling and tracking dictionaries in R.
}
\examples{
dict_file <- system.file("sample_dict.raw", package = "zstdlite", mustWork = TRUE)
dict <- readBin(dict_file, raw(), file.size(dict_file))
zstd_dict_id(dict)
compressed_mtcars <- zstd_serialize(mtcars, dict = dict)
zstd_dict_id(compressed_mtcars)
}
