% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cctx.R
\name{zstd_dctx}
\alias{zstd_dctx}
\title{Initialise a ZSTD decompression context}
\usage{
zstd_dctx(validate_checksum = TRUE, dict = NULL)
}
\arguments{
\item{validate_checksum}{If a checksum is present on the comrpessed data, 
should the checksum be validated? 
Default: TRUE.  Set to \code{FALSE} to ignore the checksum, which 
may lead to a minor speed improvement.
If no checksum is present in the compressed data, then this option has no 
effect.}

\item{dict}{Dictionary. Default: NULL. Can either be a raw vector or a filename. 
This dictionary can be created with \code{zstd_train_dict_compress()}
, \code{zstd_train_dict_seriazlie()} or any other tool supporting
\code{zstd} dictionary creation.  Note: compressed data created 
with a dictionary \emph{must} be decompressed with the same dictionary.}
}
\value{
External pointer to a ZSTD Decompression Context which can be passed to
        \code{zstd_unserialize()} and \code{zstd_decompress()}
}
\description{
Decompression contexts can be re-used, meaning that they don't have to be
created each time a decompression function is called.  This can make 
things faster when performing multiple decompression operations.
}
\examples{
dctx <- zstd_dctx(validate_checksum = FALSE)
}
