% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{session_info}
\alias{session_info}
\title{An alternative to sessionInfo() to print session information}
\usage{
session_info(packages = NULL, dependencies = TRUE)
}
\arguments{
\item{packages}{A character vector of package names, of which the versions
will be printed. If not specified, it means all loaded and attached
packages in the current R session.}

\item{dependencies}{Whether to print out the versions of the recursive
dependencies of packages.}
}
\value{
A character vector of the session information marked as
\code{\link[=raw_string]{raw_string()}}.
}
\description{
This function tweaks the output of \code{\link[=sessionInfo]{sessionInfo()}}: (1) It adds
the RStudio version information if running in the RStudio IDE; (2) It removes
the information about matrix products, BLAS, and LAPACK; (3) It removes the
names of base R packages; (4) It prints out package versions in a single
group, and does not differentiate between loaded and attached packages.
}
\details{
It also allows you to only print out the versions of specified packages (via
the \code{packages} argument) and optionally their recursive dependencies.
For these specified packages (if provided), if a function
\code{xfun_session_info()} exists in a package, it will be called and
expected to return a character vector to be appended to the output of
\code{session_info()}. This provides a mechanism for other packages to inject
more information into the \code{session_info} output. For example,
\pkg{rmarkdown} (>= 1.20.2) has a function \code{xfun_session_info()} that
returns the version of Pandoc, which can be very useful information for
diagnostics.
}
\examples{\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
xfun::session_info()
if (xfun::loadable("MASS")) xfun::session_info("MASS")
\dontshow{\}) # examplesIf}
}
