% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constant.R
\name{constant.data.frame}
\alias{constant.data.frame}
\title{Identify Constant Features of a Data Frame}
\usage{
\method{constant}{data.frame}(x, ...)
}
\arguments{
\item{x}{object}

\item{...}{optional grouping columns (named arguments are ignored)}
}
\value{
data.frame (should be same class as x)
}
\description{
Returns columns of a data.frame whose values do not vary within subsets 
defined by columns named in \dots. Defaults to groups(x) if none supplied, 
or all columns otherwise.
}
\examples{
library(dplyr)
constant(Theoph)                      # data frame with 0 columns and 1 row
constant(Theoph, Subject)             # Subject Wt Dose Study
Theoph$Study <- 1
constant(Theoph)                      # Study
constant(Theoph, Study)               # Study
constant(Theoph, Study, Subject)      # Subject Wt Dose Study
Theoph <- group_by(Theoph, Subject)
constant(Theoph)                      # Subject Wt Dose Study
constant(Theoph, Study)               # Study
}
\seealso{
Other constant: 
\code{\link{constant}()}
}
\concept{constant}
