% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workflow_map.R
\name{workflow_map}
\alias{workflow_map}
\title{Process a series of workflows}
\usage{
workflow_map(
  object,
  fn = "tune_grid",
  verbose = FALSE,
  seed = sample.int(10^4, 1),
  ...
)
}
\arguments{
\item{object}{A workflow set.}

\item{fn}{The name of the function to run, as a character. Acceptable values are:
\link[tune:tune_grid]{"tune_grid"},
\link[tune:tune_bayes]{"tune_bayes"},
\link[tune:fit_resamples]{"fit_resamples"},
\link[finetune:tune_race_anova]{"tune_race_anova"},
\link[finetune:tune_race_win_loss]{"tune_race_win_loss"}, or
\link[finetune:tune_sim_anneal]{"tune_sim_anneal"}. Note that users need not
provide the namespace or parentheses in this argument,
e.g. provide \code{"tune_grid"} rather than \code{"tune::tune_grid"} or \code{"tune_grid()"}.}

\item{verbose}{A logical for logging progress.}

\item{seed}{A single integer that is set prior to each function execution.}

\item{...}{Options to pass to the modeling function. See details below.}
}
\value{
An updated workflow set. The \code{option} column will be updated with
any options for the \code{tune} package functions given to \code{workflow_map()}. Also,
the results will be added to the \code{result} column. If the computations for a
workflow fail, a \code{try-catch} object will be saved in place of the results
(without stopping execution).
}
\description{
\code{workflow_map()} will execute the same function across the workflows in the
set. The various \verb{tune_*()} functions can be used as well as
\code{\link[tune:fit_resamples]{tune::fit_resamples()}}.
}
\details{
When passing options, anything passed in the \code{...} will be combined with any
values in the \code{option} column. The values in \code{...} will override that
column's values and the new options are added to the \code{options} column.

Any failures in execution result in the corresponding row of \code{results} to
contain a \code{try-error} object.

In cases where a model has no tuning parameters is mapped to one of the
tuning functions, \code{\link[tune:fit_resamples]{tune::fit_resamples()}} will be used instead and a
warning is issued if \code{verbose = TRUE}.

If a workflow requires packages that are not installed, a message is printed
and \code{workflow_map()} continues with the next workflow (if any).
}
\note{
The package supplies two pre-generated workflow sets, \code{two_class_set}
and \code{chi_features_set}, and associated sets of model fits
\code{two_class_res} and \code{chi_features_res}.

The \verb{two_class_*} objects are based on a binary classification problem
using the \code{two_class_dat} data from the modeldata package. The six
models utilize either a bare formula or a basic recipe utilizing
\code{recipes::step_YeoJohnson()} as a preprocessor, and a decision tree,
logistic regression, or MARS model specification. See \code{?two_class_set}
for source code.

The \verb{chi_features_*} objects are based on a regression problem using the
\code{Chicago} data from the modeldata package. Each of the three models
utilize a linear regression model specification, with three different
recipes of varying complexity. The objects are meant to approximate the
sequence of models built in Section 1.3 of Kuhn and Johnson (2019). See
\code{?chi_features_set} for source code.
}
\examples{
\dontshow{if (rlang::is_installed(c("kknn", "modeldata", "recipes", "yardstick", "dials")) && identical(Sys.getenv("NOT_CRAN"), "true")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(workflowsets)
library(workflows)
library(modeldata)
library(recipes)
library(parsnip)
library(dplyr)
library(rsample)
library(tune)
library(yardstick)
library(dials)

# An example of processed results
chi_features_res

# Recreating them:

# ---------------------------------------------------------------------------
data(Chicago)
Chicago <- Chicago[1:1195,]

time_val_split <-
   sliding_period(
      Chicago,
      date,
      "month",
      lookback = 38,
      assess_stop = 1
   )

# ---------------------------------------------------------------------------

base_recipe <-
   recipe(ridership ~ ., data = Chicago) \%>\%
   # create date features
   step_date(date) \%>\%
   step_holiday(date) \%>\%
   # remove date from the list of predictors
   update_role(date, new_role = "id") \%>\%
   # create dummy variables from factor columns
   step_dummy(all_nominal()) \%>\%
   # remove any columns with a single unique value
   step_zv(all_predictors()) \%>\%
   step_normalize(all_predictors())

date_only <-
   recipe(ridership ~ ., data = Chicago) \%>\%
   # create date features
   step_date(date) \%>\%
   update_role(date, new_role = "id") \%>\%
   # create dummy variables from factor columns
   step_dummy(all_nominal()) \%>\%
   # remove any columns with a single unique value
   step_zv(all_predictors())

date_and_holidays <-
   recipe(ridership ~ ., data = Chicago) \%>\%
   # create date features
   step_date(date) \%>\%
   step_holiday(date) \%>\%
   # remove date from the list of predictors
   update_role(date, new_role = "id") \%>\%
   # create dummy variables from factor columns
   step_dummy(all_nominal()) \%>\%
   # remove any columns with a single unique value
   step_zv(all_predictors())

date_and_holidays_and_pca <-
   recipe(ridership ~ ., data = Chicago) \%>\%
   # create date features
   step_date(date) \%>\%
   step_holiday(date) \%>\%
   # remove date from the list of predictors
   update_role(date, new_role = "id") \%>\%
   # create dummy variables from factor columns
   step_dummy(all_nominal()) \%>\%
   # remove any columns with a single unique value
   step_zv(all_predictors()) \%>\%
   step_pca(!!stations, num_comp = tune())

# ---------------------------------------------------------------------------

lm_spec <- linear_reg() \%>\% set_engine("lm")

# ---------------------------------------------------------------------------

pca_param <-
   parameters(num_comp()) \%>\%
   update(num_comp = num_comp(c(0, 20)))

# ---------------------------------------------------------------------------

chi_features_set <-
   workflow_set(
      preproc = list(date = date_only,
                     plus_holidays = date_and_holidays,
                     plus_pca = date_and_holidays_and_pca),
      models = list(lm = lm_spec),
      cross = TRUE
   )

# ---------------------------------------------------------------------------

chi_features_res_new <-
   chi_features_set \%>\%
   option_add(param_info = pca_param, id = "plus_pca_lm") \%>\%
   workflow_map(resamples = time_val_split, grid = 21, seed = 1, verbose = TRUE)

chi_features_res_new
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=workflow_set]{workflow_set()}}, \code{\link[=as_workflow_set]{as_workflow_set()}}, \code{\link[=extract_workflow_set_result]{extract_workflow_set_result()}}
}
