% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpanet_internal.R
\name{rpanet_general}
\alias{rpanet_general}
\alias{rpanet_simple}
\title{Internal functions for generating PA networks}
\usage{
rpanet_general(
  nstep,
  initial.network,
  control,
  m,
  sum_m,
  w,
  nnode,
  nedge,
  method,
  sample.recip
)

rpanet_simple(
  nstep,
  initial.network,
  control,
  m,
  sum_m,
  w,
  ex_node,
  ex_edge,
  method
)
}
\arguments{
\item{nstep}{Number of steps when generating a network.}

\item{initial.network}{A \code{wdnet} object or a list that represents the
initial network. By default, \code{initial.network} has one directed edge from node 1
to node 2 with weight 1. It may have the following components: a two-column
matrix \code{edgelist} representing the edges; a vector \code{edgeweight}
representing the weight of edges; a logical argument \code{directed} indicating
whether the initial network is directed;
an integer vector \code{nodegroup}
representing the group of nodes. \code{nodegroup} is defined for directed
networks, if \code{NULL}, all nodes from the seed network are considered
from group 1.}

\item{control}{A list of parameters that controls the PA generation process.
The default value is \code{wdnet:::rpa_control_default()}. By default, in
each step, a new edge of weight 1 is added from a new node \code{A} to an
existing node \code{B} (\code{alpha} scenario), where $\code{B} is chosen
with probability proportional to its in-strength + 1.}

\item{m}{Integer vector, number of new edges in each step.}

\item{sum_m}{Integer, summation of \code{m}.}

\item{w}{Vector, weight of new edges.}

\item{nnode}{Integer, number of nodes in \code{initial.network}.}

\item{nedge}{Integer, number of edges in \code{initial.network}.}

\item{method}{Which method to use when generating PA networks: "binary" or
"linear".}

\item{sample.recip}{Whether reciprocal edges will be added.}
}
\value{
Returns a \code{wdnet} object that includes the following components:
\itemize{
\item \code{directed}: Logical, whether the network is directed.
\item \code{weighted}: Logical, whether the network is weighted.
\item \code{edgelist}: A two-column matrix representing the edges.
\item \code{edge.attr}: A data frame including edge weights and edge
scenarios (0: from initial network; 1: \code{alpha}; 2: \code{beta};
3: \code{gamma}; 4: \code{xi}; 5; \code{rho}; 6: reciprocal edge).
\item \code{node.attr}: A data frame including node out- and
in-strength, node source and target preference scores (for directed
networks), node strength and preference scores (for undirected
networks), and node group (if applicable).
\item \code{newedge}: The number of new edges at each step, including
reciprocal edges.
\item \code{control}: An \code{rpacontrol} object that is used to
generate the network.
}
}
\description{
These functions generate a PA network with linear (\code{rpanet_simple}) or
non-linear (\code{rpanet_general}) preference functions
}
\keyword{internal}
