% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WrapperFuncs.R
\name{PrepareSEForVSClust}
\alias{PrepareSEForVSClust}
\title{Wrapper for statistical analysis for SummarizedExperiment object}
\usage{
PrepareSEForVSClust(
  se,
  assayname = 1,
  coldatname = NULL,
  isPaired = FALSE,
  isStat
)
}
\arguments{
\item{se}{SummarizedExperiment object}

\item{assayname}{Sample in SummarizedExperiment object}

\item{coldatname}{Column in colData for extracting replicates}

\item{isPaired}{Boolean for running paired or unpaired statistical tests}

\item{isStat}{Boolean for whether to run statistical test or each column
corresponds to a different experimental conditions. Then this function reads
feature standard deviations from data frame from the last column}
}
\value{
list with the items `dat` (data matrix of features averaged over
replicates and last column with their standard deviations), `qvals` FDRs from
the statistical tests (each conditions versus the first), `StatFileOut` all
of before for saving in file, `NumReps` number of replicates and `NumCond` 
number of different experimental conditions
}
\description{
Prepare data for running vsclust clustering.
This includes visualization running the functions for the principal component
analysis and its visualization, statistical testing with LIMMA, as well as
scaling and filtering of missing values
}
\examples{
data(miniACC, package="MultiAssayExperiment")

stats <- PrepareSEForVSClust(miniACC, coldatname="COC", isStat=TRUE)

}
\references{
Schwaemmle V, Jensen ON. VSClust: feature-based variance-sensitive clustering
of omics data. Bioinformatics. 2018 Sep 1;34(17):2965-2972. doi:
10.1093/bioinformatics/bty224. PMID: 29635359.

Schwaemmle V, Hagensen CE. A Tutorial for Variance-Sensitive Clustering and
the Quantitative Analysis of Protein Complexes. Methods Mol Biol.
2021;2228:433-451. doi: 10.1007/978-1-0716-1024-4_30. PMID: 33950508.

Schwaemmle V, Jensen ON. A simple and fast method to determine the parameters
for fuzzy c-means cluster analysis. Bioinformatics. 2010
Nov 15;26(22):2841-8. doi: 10.1093/bioinformatics/btq534. Epub 2010 Sep 29.
PMID: 20880957.
}
