% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Create.twomode.twitter.R
\name{Create.twomode.twitter}
\alias{Create.twomode.twitter}
\title{Create twitter 2-mode network}
\usage{
\method{Create}{twomode.twitter}(
  datasource,
  type,
  removeTermsOrHashtags = NULL,
  rmRetweets = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{datasource}{Collected social media data with \code{"datasource"} and \code{"twitter"} class names.}

\item{type}{Character string. Type of network to be created, set to \code{"twomode"}.}

\item{removeTermsOrHashtags}{Character vector. Users or hashtags to remove from the twomode network. For example,
this parameter could be used to remove the user or hashtag that was used to collect the data by removing any nodes
with matching name. Default is \code{NULL} to remove none.}

\item{rmRetweets}{Logical. Do not process retweets in the input data. Default is \code{TRUE}.}

\item{verbose}{Logical. Output additional information about the network creation. Default is \code{TRUE}.}

\item{...}{Additional parameters passed to function. Not used in this method.}
}
\value{
Network as a named list of two dataframes containing \code{$nodes} and \code{$edges}.
}
\description{
Creates a 2-mode network from tweets returned from the twitter search query. In this network there are
two types of nodes, twitter users who authored or were mentioned in collected tweets and hashtags found within
tweets. Network edges represent a users tweets that contain hashtags or mention users screen names.

The creation of twitter 2-mode networks requires text processing and the tokenization of tweets. As such this
function requires the additional installation of the \pkg{tidytext} package to achieve this.
}
\examples{
\dontrun{
# twitter 2-mode network creation additionally requires the tidytext
# package for working with text data
# install.packages("tidytext")

# create a twitter 2-mode network graph with the hashtag "#auspol" removed
net_2mode <- collect_tw |>
  Create("twomode", removeTermsOrHashtags = c("#auspol"), verbose = TRUE)

# network
# net_2mode$nodes
# net_2mode$edges
}

}
