% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unjoin.R
\name{unjoin}
\alias{unjoin}
\alias{unjoin.data.frame}
\alias{unjoin.unjoin}
\title{unjoin}
\usage{
unjoin(data, ..., key_col = "idx0")

\method{unjoin}{data.frame}(data, ..., key_col = ".idx0")

\method{unjoin}{unjoin}(data, ..., key_col = ".idx0")
}
\arguments{
\item{data}{A data frame.}

\item{...}{Specification of columns to unjoin by.  For full details, see the `dplyr::select`` documentation.}

\item{key_col}{The name of the new column to key the two output data frames.}
}
\description{
Split a table in two and remove repeated values.
}
\details{
The data frame on input is treated as "data", the new data frame is treated
as the normalized key. This means that the split-off and de-duplicated table has the name given via
the `key_col` argument (defaults to ".idx0") and shares this name with the common key.

It's not yet clear if this flexibility around naming is a good idea, but it enables a simple scheme for chaining
unjoins, though you'd better not use the same `key_col` again.

This is a subset of the tasks done by \code{\link[tidyr]{nest}}.
}
\examples{
library(dplyr)
data("Seatbelts", package= "datasets")
x <- unjoin(as.data.frame(Seatbelts), front, law)
y <- inner_join(x$.idx0, x$data) \%>\% select(-.idx0)
all.equal(y[colnames(Seatbelts)], as.data.frame(Seatbelts))

iris \%>\% unjoin(-Species)
chickwts \%>\% unjoin(weight)

if (require("gapminder")) {
  gapminder \%>\%
    group_by(country, continent) \%>\%
    unjoin()

  gapminder \%>\%
    unjoin(-country, -continent)
  unjoin(gapminder)
}
unjoin(iris, Petal.Width) \%>\% unjoin(Species, key_col = ".idx1")
}
\seealso{
`dplyr::inner_join` for the inverse operation.

`tidyr::nest` for the complementary operation resulting in one nested data frame
}
