% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.ols.R
\name{ui.ols}
\alias{ui.ols}
\title{Uncertainty intervals for OLS regression}
\usage{
ui.ols(out.formula, mis.formula = NULL, data, rho = c(-0.3, 0.3),
  alpha = 0.05, gridn = 101)
}
\arguments{
\item{out.formula}{Formula for outcome regression.}

\item{mis.formula}{Formula for missingness mechanism. If NULL the same covariates as in the outcome regression will be used.}

\item{data}{data.frame containing the variables in the formula.}

\item{rho}{The limits of rho for which the uncertainty interval should be constructed.}

\item{alpha}{Default 0.05 corresponding to a confidence level of 95 for CI and UI.}

\item{gridn}{The number of distinct points within the interval \code{rho} at which confidence intervals should be constructed. Default is 101.}
}
\value{
A list containing:
\item{call}{The matched call}
\item{ci}{Confidence intervals for different values of \code{rho}}
\item{ui}{Uncertainty intervals}
\item{coef}{Estimated coefficients (outcome regression) for different values of \code{rho}}
\item{out.model}{Outcome regression model when rho=0.}
\item{mis.model}{Regression model for missingness mechanism (selection).}
\item{rho}{The range of \code{rho} for which we want to construct an uncertainty interval}
\item{gridrho}{The values of \code{rho} for which bias and standard errors are derived}
\item{sigma}{Consistant estimate of sigma}
\item{se}{Standard error for different values of \code{rho}}
\item{ciols}{Confidence intervals from a complete case analysis}
\item{ident.bound}{Bounds for the coefficient estimates.}
}
\description{
This function allows you to derive uncertainty intervals for OLS regression when there is missing data in the continuous outcome. The uncertainty intervals can be used as a sensitivity analysis to ignorability (missing at random). Note that rho=0 render the same results as a complete case analysis.
}
\details{
In order to visualize the results, you can use \code{\link{plot.uiols}}, 
or \code{\link{profile.uiols}}.
}
\examples{
library(MASS)
n<-500
delta<-c(0.5,0.3,0.1)
beta<-c(0.8,-0.2,0.3)
X<-cbind(rep(1,n),rnorm(n),rbinom(n,1,0.5))
x<-X[,-1]
rho=0.4
error<-mvrnorm(n,c(0,0),matrix(c(1,rho*2,rho*2,4),2))
zstar<-X\%*\%delta+error[,1]
z<-as.numeric(zstar>0)
y<-X\%*\%beta+error[,2]
y[z==0]<-NA
data<-data.frame(y,x,z)
ui<-ui.ols(y~X1+X2,data=data,rho=c(-0.5,0.5))
ui
plot(ui)

}
\references{
Genbäck, M., Stanghellini, E., de Luna, X. (2015). Uncertainty Intervals for Regression Parameters with Non-ignorable Missingness in the Outcome. \emph{Statistical Papers}, 56(3), 829-847.
}
\author{
Minna Genbäck
}
