% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/carelessObject.R
\name{carelessObject}
\alias{carelessObject}
\title{Compute diagnostics for careless responding}
\usage{
carelessObject(
  data,
  items = names(data),
  flagUnivar = 0.99,
  flagMultivar = 0.95,
  irvSplit = 4,
  responseTime = NULL
)
}
\arguments{
\item{data}{The dataframe.}

\item{items}{The items to look at.}

\item{flagUnivar}{How extreme a score has to be for it
to be flagged as suspicous univariately.}

\item{flagMultivar}{This has not been implemented yet.}

\item{irvSplit}{Whether to split for the IRV, and if so,
in how many parts.}

\item{responseTime}{If not \code{NULL}, the name of a column
containing the participants' response times.}
}
\value{
An object of class \code{carelessObject}.
}
\description{
This function is a wrapper for the functions from
the \code{careless} package. Normally, you'd probably
call \code{carelessReport} which calls this function
to generate a report of suspect participants.
}
\examples{
carelessObject(mtcars);
}
