% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvPLM.R
\name{tvPLM}
\alias{tvPLM}
\alias{tvplm-class}
\alias{tvplm}
\title{Time-Varying Coefficients Panel Data Models}
\usage{
tvPLM(
  formula,
  z = NULL,
  ez = NULL,
  data,
  index = NULL,
  bw = NULL,
  bw.cov = NULL,
  cv.block = 0,
  method = c("pooling", "random", "within"),
  est = c("lc", "ll"),
  tkernel = c("Triweight", "Epa", "Gaussian"),
  control = tvreg.control(...),
  ...
)
}
\arguments{
\item{formula}{An object of class formula.}

\item{z}{A vector containing the smoothing variable.}

\item{ez}{(optional) A scalar or vector with the smoothing values. If 
values are not included then the vector \code{z} is used instead.}

\item{data}{An optional data frame or matrix.}

\item{index}{Indicates the individual and time indexes.}

\item{bw}{An opcional scalar. It represents the bandwidth in
the estimation of trend coefficients. If NULL, it is selected by cross validation.}

\item{bw.cov}{An optional scalar. It represents the bandwidth in the "lc" nonparametric estimation of the
time-varying covariance matrix. If NULL, it is selected by cross validation for method \code{"random"}.}

\item{cv.block}{A positive scalar with the size of the block in leave one block out cross-validation.
By default 'cv.block=0' meaning leave one out cross-validation.}

\item{method}{A character with the choice of panel model/estimation method:
If \code{method = "pooling"} (default) then the data is pooled estimated with time-varying OLS. 
No individual or time effects are estimated
If \code{method = "random"} then individual effects are considered random and independent
of the regressors.
If \code{method = "within"} then individual effects which might be correlated with 
the regressors are estimated.}

\item{est}{The nonparametric estimation method, one of "lc" (default) for linear constant}

\item{tkernel}{A character, either "Triweight" (default), "Epa" or "Gaussian" kernel function.}

\item{control}{list of control parameters.  The default is constructed by
the function \code{\link{tvreg.control}}.  See the documentation of
\code{\link{tvreg.control}} for details.}

\item{...}{Other parameters passed to specific methods.}
}
\value{
\code{tvPLM} returns a list of the class \code{tvplm} containing the results of model, results of the estimation
and confidence instervals if chosen.
The object of class \code{tvplm} have the following components:
\item{coefficients}{An array of dimension obs x nvar x neq (obs = number of observations, nvar = number of variables
in each equation, neq = number of equations in the system) with the time-varying coefficients estimates.}
\item{Lower}{If \code{level} non equal zero, an array of dimension obs x nvar x neq containing the confidence 
interval lower band.}
\item{Upper}{If \code{level} non equal zero, an array of dimension obs x nvar x neq containing the confidence 
interval upper band.}
\item{fitted}{The fitted values.}
\item{residuals}{Estimation residuals.}
\item{x}{A list with the regressors data.}
\item{y}{A matrix with the dependent variable data.}
\item{z}{A vector with the smoothing variable.}
\item{ez}{A vector with the smoothing estimation values.}
\item{alpha}{A vector with the individual fixed effects, if chosen.}
\item{bw}{Bandwidth of mean estimation.}
\item{totobs}{Integer specifying the total number of observations.}
\item{neq}{Integer specifying the number of cross-section observations.}
\item{obs}{Integer specifying the number of time observations per cross-section.}
\item{nvar}{Number of variables.}
\item{method}{Estimation method.}
\item{est}{Nonparemtric estimation methodology.}
\item{tkernel}{Kernel type.}
\item{level}{Confidence interval range.}
\item{runs}{Number of bootstrap replications.}
\item{tboot}{Type of bootstrap.}
\item{BOOT}{List with all bootstrap replications of \code{coefficients}, if done.}
\item{formula}{Initial formula.}
\item{call}{Matched call.}
}
\description{
Fits a balanced panel data model using the Time-Varying Pooled Ordinary Least 
Squares, the Time-Varying Random Effects and the Time-Varying Fixed Effects models.
}
\details{
This function wraps up the kernel smoothing time-varying coefficient pooled, random effects
and fixed effects estimators. 

Bandwidth selection is of great importance in kernel smoothing methodologies and it is done
automatically by cross-validation. 

A panel data model consists of "neq" elements in the cross-sectional dimention and
 "obs" number of time observations for each cross-section. All variables are
the same for each equation which have common coefficients.
}
\examples{
data(OECD)
##TVPOLS estimation of the model
tvpols <- tvPLM(lhe~lgdp+pop65+pop14+public, index = c("country", "year"),
 data = OECD, method ="pooling", bw = 0.3)
\dontrun{
tvfe <- tvPLM(lhe~lgdp+pop65+pop14+public, index = c("country", "year"),
 data = OECD, method ="within", bw = 0.8)
tvre <- tvPLM(lhe~lgdp+pop65+pop14+public, index = c("country", "year"),
 data = OECD, method ="random", bw = 0.3)
}
}
\references{
Casas, I., Gao, J., Peng, B. and Xie, S. (2021). Time-Varying Income Elasticities 
of Healthcare Expenditure for the OECD and Eurozone. 
\emph{Journal of Applied Econometrics, 36, pp. 328-345}. 

Sun, Y., Carrol, R.J and Li, D. (2009). Semiparametric Estimation of Fixed-Effects Panel Data 
Varying Coefficient Models. \emph{Advances in Econometrics}, 25, pp. 101-129.
}
\seealso{
\code{\link{bw}}, \code{\link{confint}}, \code{\link{plot}}, 
\code{\link{print}} and \code{\link{summary}}
}
