% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moments.R
\name{authorized_domain}
\alias{authorized_domain}
\title{Distribution Authorized Domain}
\usage{
authorized_domain(distribution, max_kurt = 30, n = 25, lambda = 1)
}
\arguments{
\item{distribution}{a valid distribution with skew and shape parameters.}

\item{max_kurt}{the maximum kurtosis for which to determine the bounds for
the skewness-kurtosis domain.}

\item{n}{the number of points between the lower and upper bounds of the
skew and shape parameters for which to evaluate the skewness and excess kurtosis.
This determines the kurtosis interval (3 - max_kurt) for which to
calculate (solver based) the maximum skewness.}

\item{lambda}{additional shape parameter for the Generalized Hyperbolic
distribution.}
}
\value{
A list with the lower half of the skewness and kurtosis values.
}
\description{
Calculated the region of Skewness-Kurtosis for which a density exists.
}
