% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtransforms.R
\name{vinverse}
\alias{vinverse}
\title{Calculate inverse of v-transform}
\usage{
vinverse(x, v, tol = .Machine$double.eps^0.75)
}
\arguments{
\item{x}{an object ofc lass \linkS4class{Vtransform}.}

\item{v}{a vector or time series with values in [0, 1].}

\item{tol}{the desired accuracy (convergence tolerance) that is passed to
\code{uniroot} if numerical inversion is used.}
}
\value{
A vector or time series with values in [0, 1].
}
\description{
If the \linkS4class{Vtransform} object is also a \linkS4class{VtransformI} object (an
invertible v-transform) then the analytical inverse is used. Otherwise
an inverse is found by numerical root finding with \code{\link[stats]{uniroot}}.
}
\examples{
vinverse(Vsymmetric(), c(0, 0.25, 0.5, 0.75, 1))
}
