% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stan_nbg.R
\name{stan_nbg}
\alias{stan_nbg}
\title{Fit a Neuenschwander, Branson & Gsponer logit dose-finding model}
\usage{
stan_nbg(
  outcome_str = NULL,
  real_doses,
  d_star,
  target,
  alpha_mean = NULL,
  alpha_sd = NULL,
  beta_mean = NULL,
  beta_sd = NULL,
  doses_given = NULL,
  tox = NULL,
  weights = NULL,
  ...
)
}
\arguments{
\item{outcome_str}{A string representing the outcomes observed hitherto.
See \code{\link{df_parse_outcomes}} for a description of syntax and
examples. Alternatively, you may provide \code{doses_given} and \code{tox}
parameters. See Details.}

\item{real_doses}{A vector of numbers, the doses under investigation. They
should be ordered from lowest to highest and be in consistent units.
E.g. to conduct a dose-finding trial of doses 10mg, 20mg and 50mg, use
c(10, 20, 50).}

\item{d_star}{d_star, numeric reference dose-level. The linear covariate
in this logit model is \code{dose / d_star}.}

\item{target}{the target toxicity probability, a number between 0 and 1.}

\item{alpha_mean}{Prior mean of intercept variable for normal prior.
See Details.}

\item{alpha_sd}{Prior standard deviation of intercept variable for normal prior.
See Details.}

\item{beta_mean}{Prior mean of gradient variable for normal prior.
See Details.}

\item{beta_sd}{Prior standard deviation of slope variable for normal prior.
See Details.}

\item{doses_given}{A optional vector of dose-levels given to patients
1:num_patients, where 1=lowest dose, 2=second dose, etc. Only required when
\code{outcome_str} is not provided.}

\item{tox}{An optional vector of toxicity outcomes for patients
1:num_patients, where 1=toxicity and 0=no toxicity. Only required when
\code{outcome_str} is not provided.}

\item{weights}{An optional vector of numeric weights for the observations
for patients 1:num_patients, thus facilitating a time-to-event (TITE) design.
Can be used with \code{outcome_str}, or with \code{doses_given} and
\code{tox}. It is generally tidier to specify \code{doses_given},
\code{tox} and \code{weights} when a TITE-analysis is desired.}

\item{...}{Extra parameters are passed to \code{rstan::sampling}. Commonly
used options are \code{iter}, \code{chains}, \code{warmup}, \code{cores}, and
\code{control}.}
}
\value{
An object of class \code{nbg_fit}, which inherits behaviour from
\code{\link{crm_fit}}.
}
\description{
Fit Neuenschwander, Branson & Gsponer logit model for dose-finding using Stan
for full Bayesian inference.
}
\details{
The quickest and easiest way to fit this model to some observed outcomes
is to describe the outcomes using \pkg{trialr}'s syntax for dose-finding
outcomes. See \code{\link{df_parse_outcomes}} for full details and examples.

The two-parameter model form is:

\eqn{F(x_{i}, \alpha, \beta) = 1 / (1 + \exp{-(\alpha + \exp{(\beta)} log(x_i / d_star))}) }

and the required parameters are:

\itemize{
  \item \code{alpha_mean}
  \item \code{alpha_sd}
  \item \code{beta_mean}
  \item \code{beta_sd}
}
}
\examples{
\dontrun{
# Non-TITE example:
fit1 <- stan_nbg('1NNN 2NNN 3TTT', real_doses = c(10, 20, 50, 100, 200),
                 d_star = 200, target = 0.25,
                 alpha_mean = -1, alpha_sd = 2,
                 beta_mean = 0, beta_sd = 1,
                 seed = 123)
fit1$recommended_dose

# The seed is passed to the Stan sampler. The usual Stan sampler params like
# cores, iter, chains etc are passed on too via the ellipsis operator.

# TITE-CRM example
fit2 <-stan_nbg(real_doses = c(10, 20, 50, 100, 200), d_star = 200,
                target = 0.25,
                doses_given = c(3, 3, 3, 3),
                tox = c(0, 0, 0, 0),
                weights = c(73, 66, 35, 28) / 126,
                alpha_mean = -1, alpha_sd = 2,
                beta_mean = 0, beta_sd = 1,
                seed = 123)
fit2$recommended_dose
}
}
\references{
Neuenschwander, B., Branson, M., & Gsponer, T. (2008).
  Critical aspects of the Bayesian approach to phase I cancer trials.
  Statistics in Medicine, 27, 2420–2439. https://doi.org/10.1002/sim
}
\seealso{
\code{\link{crm_fit}}
  \code{\link[rstan:sampling]{sampling}}
}
\author{
Kristian Brock \email{kristian.brock@gmail.com}
}
