% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeqza.R
\name{read.treeqza}
\alias{read.treeqza}
\title{read.treeqza}
\usage{
read.treeqza(treeqza, node.label = "label", ...)
}
\arguments{
\item{treeqza}{the qiime2 output file contained tree file.}

\item{node.label}{parse node label as 'label' or 'support' value.}

\item{...}{additional parameter, passed to 'read.tree'.}
}
\value{
phylo tree object or treedata object when node.label was parsed 'support'.
}
\description{
read.treeqza
}
\examples{
qzafile1 <- system.file("extdata/qiime2treeqza", "fasttree-tree.qza", package="treeio")
qzafile2 <- system.file("extdata/qiime2treeqza", "iqt-tree.qza", package="treeio")
qzafile3 <- system.file("extdata/qiime2treeqza", "raxml-cat-tree.qza", package="treeio")
tr1 <- read.treeqza(qzafile1)
tr1
tr2 <- read.treeqza(qzafile2)
tr2
tr3 <- read.treeqza(qzafile3)
tr3
# parse node label as 'support' value.
qzafile4 <- system.file("extdata/qiime2treeqza", "raxml-cat-bootstrap-tree.qza", package="treeio")
tr4 <- read.treeqza(qzafile4, node.label="support")
tr4
}
