% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_missing.R
\name{process_missing}
\alias{process_missing}
\title{Preprocess Data to Handle Missing Variables}
\usage{
process_missing(
  data,
  node_list,
  complete_nodes = c("A", "Y"),
  impute_nodes = NULL,
  max_p_missing = 0.5
)
}
\arguments{
\item{data, }{\code{data.table}, containing the missing variables}

\item{node_list, }{\code{list}, what variables comprise each node}

\item{complete_nodes, }{\code{character vector}, nodes we must observe}

\item{impute_nodes, }{\code{character vector}, nodes we will impute}

\item{max_p_missing, }{\code{numeric}, what proportion of missing is tolerable? Beyond that, the variable will be dropped from the analysis}
}
\value{
\code{list} containing the following elements:
\itemize{
\item \code{data}, the updated dataset
\item \code{node_list}, the updated list of nodes
\item \code{n_dropped}, the number of observations dropped
\item \code{dropped_cols}, the variables dropped due to excessive missingness

}
}
\description{
Process data to account for missingness in preparation for TMLE
}
\details{
Rows where there is missingness in any of the \code{complete_nodes} will be
dropped. Then, missingness will be median-imputed for the variables in the \code{impute_nodes}.
Indicator variables of missingness will be generated for these nodes.

Then covariates will be processed as follows:
\enumerate{
\item any covariate with more than \code{max_p_missing} missingness will be dropped
\item indicators of missingness will be generated
\item missing values will be median-imputed
}
}
