% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Param_mean.R
\name{Param_mean}
\alias{Param_mean}
\title{Mean of Outcome Node}
\format{
\code{\link{R6Class}} object.
}
\value{
\code{Param_base} object
}
\description{
Parameter for marginal mean of Y: \eqn{\Psi=E[Y]}. No TMLE update needed, but can be used in delta method calculations.
Useful for example, in calculating attributable risks.
}
\section{Constructor}{

\code{define_param(Param_TSM, observed_likelihood, intervention_list, ..., outcome_node)}

\describe{
\item{\code{observed_likelihood}}{A \code{\link{Likelihood}} corresponding to the observed likelihood
}
\item{\code{...}}{Not currently used.
}
\item{\code{outcome_node}}{character, the name of the node that should be treated as the outcome
}
}
}

\section{Fields}{

\describe{
\item{\code{cf_likelihood}}{the counterfactual likelihood for this treatment
}
\item{\code{intervention_list}}{A list of objects inheriting from \code{\link{LF_base}}, representing the intervention
}
}
}

\seealso{
Other Parameters: 
\code{\link{Param_ATC}},
\code{\link{Param_ATE}},
\code{\link{Param_ATT}},
\code{\link{Param_MSM}},
\code{\link{Param_TSM}},
\code{\link{Param_base}},
\code{\link{Param_delta}},
\code{\link{Param_stratified}},
\code{\link{Param_survival}},
\code{\link{define_param}()},
\code{\link{tmle3_Fit}}
}
\concept{Parameters}
\keyword{data}
