% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Param_base.R
\name{Param_base}
\alias{Param_base}
\title{Base Class for Defining Parameters}
\format{
\code{\link{R6Class}} object.
}
\value{
\code{Param_base} object
}
\description{
A parameter is a function of the likelihood. Once given a \code{\link{Likelihood}} object, a parameter will a value.
These objects also contain information about the efficient influence function (EIF) of a parameter, as well as its clever covariate(s).
}
\section{Constructor}{

\code{define_param(Param_base, observed_likelihood, ..., outcome_node)}

\describe{
\item{\code{observed_likelihood}}{A \code{\link{Likelihood}} corresponding to the observed likelihood
}
\item{\code{...}}{Not currently used.
}
\item{\code{outcome_node}}{character, the name of the node that should be treated as the outcome
}
}
}

\section{Methods}{


\describe{
\item{\code{clever_covariates(tmle_task = NULL)}}{
Get the clever covariates for an TMLE update step.

\itemize{
\item{\code{tmle_task}: \code{\link{tmle3_Task}} to get clever covariate values for.
If NULL, the \code{tmle_task} used to train the \code{observed likelihood will be used}
}
}
}
\item{\code{estimates(tmle_task = NULL)}}{
Get the parameter estimates and influence curve values.

\itemize{
\item{\code{tmle_task}: \code{\link{tmle3_Task}} to get clever covariate values for.
If NULL, the \code{tmle_task} used to train the \code{observed likelihood will be used}
}
}
}
}
}

\section{Fields}{

\describe{
\item{\code{observed_likelihood}}{the observed likelihood
}
\item{\code{outcome_node}}{character, the name of the outcome node
}
}
}

\seealso{
Other Parameters: 
\code{\link{Param_ATC}},
\code{\link{Param_ATE}},
\code{\link{Param_ATT}},
\code{\link{Param_MSM}},
\code{\link{Param_TSM}},
\code{\link{Param_delta}},
\code{\link{Param_mean}},
\code{\link{Param_stratified}},
\code{\link{Param_survival}},
\code{\link{define_param}()},
\code{\link{tmle3_Fit}}
}
\concept{Parameters}
\keyword{data}
