% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups_equal.R
\name{groups_equal}
\alias{groups_equal}
\title{Are groups equal?}
\usage{
groups_equal(x, y)
}
\arguments{
\item{x}{A \code{grouped_df}.}

\item{y}{A \code{grouped_df}.}
}
\value{
A logical indicating whether the groups are identical or not.
}
\description{
This function is a very fast utility for quickly checking if
the group data between 2 data frames are identical.
}
\examples{
library(dplyr)
library(timeplyr)

df <- iris \%>\%
  group_by(Species)
df2 <- iris \%>\%
  fslice_sample(seed = 1777) \%>\%
  group_by(Species)

groups_equal(iris, iris)
groups_equal(df, df)
groups_equal(df, df2)

}
