## code to prepare `whitebox_coltab` dataset goes here

library(tidyverse)

# From https://github.com/jblindsay/whitebox-tools/blob/5e9aabd68a5fa4660e84ff798e0a06cfedb5a179/whitebox-tools-app/src/tools/terrain_analysis/hypsometrically_tinted_hillshade.rs

whitebox_coltab <- tibble::tribble(
  ~pal, ~r, ~g, ~b,
  "atlas", 72L, 135L, 55L,
  "atlas", 226L, 219L, 171L,
  "atlas", 228L, 180L, 123L,
  "high", 72L, 135L, 55L,
  "high", 226L, 219L, 171L,
  "high", 228L, 180L, 123L,
  "high", 182L, 156L, 144L,
  "high", 255L, 255L, 255L,
  "arid", 119L, 101L, 91L,
  "arid", 254L, 213L, 132L,
  "arid", 254L, 252L, 231L,
  "soft", 154L, 206L, 111L,
  "soft", 255L, 254L, 211L,
  "soft", 255L, 160L, 100L,
  "muted", 72L, 136L, 184L,
  "muted", 142L, 199L, 167L,
  "muted", 255L, 254L, 198L,
  "muted", 228L, 116L, 79L,
  "muted", 197L, 74L, 82L,
  "purple", 118L, 42L, 131L,
  "purple", 153L, 112L, 171L,
  "purple", 194L, 165L, 207L,
  "purple", 231L, 212L, 232L,
  "purple", 247L, 247L, 247L,
  "purple", 217L, 240L, 211L,
  "purple", 166L, 219L, 160L,
  "purple", 90L, 174L, 97L,
  "purple", 27L, 120L, 55L,
  "viridi", 68L, 1L, 84L,
  "viridi", 68L, 2L, 85L,
  "viridi", 68L, 3L, 87L,
  "viridi", 69L, 5L, 88L,
  "viridi", 69L, 6L, 90L,
  "viridi", 69L, 8L, 91L,
  "viridi", 70L, 9L, 92L,
  "viridi", 70L, 11L, 94L,
  "viridi", 70L, 12L, 95L,
  "viridi", 70L, 14L, 97L,
  "viridi", 71L, 15L, 98L,
  "viridi", 71L, 17L, 99L,
  "viridi", 71L, 18L, 101L,
  "viridi", 71L, 20L, 102L,
  "viridi", 71L, 21L, 103L,
  "viridi", 71L, 22L, 105L,
  "viridi", 71L, 24L, 106L,
  "viridi", 72L, 25L, 107L,
  "viridi", 72L, 26L, 108L,
  "viridi", 72L, 28L, 110L,
  "viridi", 72L, 29L, 111L,
  "viridi", 72L, 30L, 112L,
  "viridi", 72L, 32L, 113L,
  "viridi", 72L, 33L, 114L,
  "viridi", 72L, 34L, 115L,
  "viridi", 72L, 35L, 116L,
  "viridi", 71L, 37L, 117L,
  "viridi", 71L, 38L, 118L,
  "viridi", 71L, 39L, 119L,
  "viridi", 71L, 40L, 120L,
  "viridi", 71L, 42L, 121L,
  "viridi", 71L, 43L, 122L,
  "viridi", 71L, 44L, 123L,
  "viridi", 70L, 45L, 124L,
  "viridi", 70L, 47L, 124L,
  "viridi", 70L, 48L, 125L,
  "viridi", 70L, 49L, 126L,
  "viridi", 69L, 50L, 127L,
  "viridi", 69L, 52L, 127L,
  "viridi", 69L, 53L, 128L,
  "viridi", 69L, 54L, 129L,
  "viridi", 68L, 55L, 129L,
  "viridi", 68L, 57L, 130L,
  "viridi", 67L, 58L, 131L,
  "viridi", 67L, 59L, 131L,
  "viridi", 67L, 60L, 132L,
  "viridi", 66L, 61L, 132L,
  "viridi", 66L, 62L, 133L,
  "viridi", 66L, 64L, 133L,
  "viridi", 65L, 65L, 134L,
  "viridi", 65L, 66L, 134L,
  "viridi", 64L, 67L, 135L,
  "viridi", 64L, 68L, 135L,
  "viridi", 63L, 69L, 135L,
  "viridi", 63L, 71L, 136L,
  "viridi", 62L, 72L, 136L,
  "viridi", 62L, 73L, 137L,
  "viridi", 61L, 74L, 137L,
  "viridi", 61L, 75L, 137L,
  "viridi", 61L, 76L, 137L,
  "viridi", 60L, 77L, 138L,
  "viridi", 60L, 78L, 138L,
  "viridi", 59L, 80L, 138L,
  "viridi", 59L, 81L, 138L,
  "viridi", 58L, 82L, 139L,
  "viridi", 58L, 83L, 139L,
  "viridi", 57L, 84L, 139L,
  "viridi", 57L, 85L, 139L,
  "viridi", 56L, 86L, 139L,
  "viridi", 56L, 87L, 140L,
  "viridi", 55L, 88L, 140L,
  "viridi", 55L, 89L, 140L,
  "viridi", 54L, 90L, 140L,
  "viridi", 54L, 91L, 140L,
  "viridi", 53L, 92L, 140L,
  "viridi", 53L, 93L, 140L,
  "viridi", 52L, 94L, 141L,
  "viridi", 52L, 95L, 141L,
  "viridi", 51L, 96L, 141L,
  "viridi", 51L, 97L, 141L,
  "viridi", 50L, 98L, 141L,
  "viridi", 50L, 99L, 141L,
  "viridi", 49L, 100L, 141L,
  "viridi", 49L, 101L, 141L,
  "viridi", 49L, 102L, 141L,
  "viridi", 48L, 103L, 141L,
  "viridi", 48L, 104L, 141L,
  "viridi", 47L, 105L, 141L,
  "viridi", 47L, 106L, 141L,
  "viridi", 46L, 107L, 142L,
  "viridi", 46L, 108L, 142L,
  "viridi", 46L, 109L, 142L,
  "viridi", 45L, 110L, 142L,
  "viridi", 45L, 111L, 142L,
  "viridi", 44L, 112L, 142L,
  "viridi", 44L, 113L, 142L,
  "viridi", 44L, 114L, 142L,
  "viridi", 43L, 115L, 142L,
  "viridi", 43L, 116L, 142L,
  "viridi", 42L, 117L, 142L,
  "viridi", 42L, 118L, 142L,
  "viridi", 42L, 119L, 142L,
  "viridi", 41L, 120L, 142L,
  "viridi", 41L, 121L, 142L,
  "viridi", 40L, 122L, 142L,
  "viridi", 40L, 122L, 142L,
  "viridi", 40L, 123L, 142L,
  "viridi", 39L, 124L, 142L,
  "viridi", 39L, 125L, 142L,
  "viridi", 39L, 126L, 142L,
  "viridi", 38L, 127L, 142L,
  "viridi", 38L, 128L, 142L,
  "viridi", 38L, 129L, 142L,
  "viridi", 37L, 130L, 142L,
  "viridi", 37L, 131L, 141L,
  "viridi", 36L, 132L, 141L,
  "viridi", 36L, 133L, 141L,
  "viridi", 36L, 134L, 141L,
  "viridi", 35L, 135L, 141L,
  "viridi", 35L, 136L, 141L,
  "viridi", 35L, 137L, 141L,
  "viridi", 34L, 137L, 141L,
  "viridi", 34L, 138L, 141L,
  "viridi", 34L, 139L, 141L,
  "viridi", 33L, 140L, 141L,
  "viridi", 33L, 141L, 140L,
  "viridi", 33L, 142L, 140L,
  "viridi", 32L, 143L, 140L,
  "viridi", 32L, 144L, 140L,
  "viridi", 32L, 145L, 140L,
  "viridi", 31L, 146L, 140L,
  "viridi", 31L, 147L, 139L,
  "viridi", 31L, 148L, 139L,
  "viridi", 31L, 149L, 139L,
  "viridi", 31L, 150L, 139L,
  "viridi", 30L, 151L, 138L,
  "viridi", 30L, 152L, 138L,
  "viridi", 30L, 153L, 138L,
  "viridi", 30L, 153L, 138L,
  "viridi", 30L, 154L, 137L,
  "viridi", 30L, 155L, 137L,
  "viridi", 30L, 156L, 137L,
  "viridi", 30L, 157L, 136L,
  "viridi", 30L, 158L, 136L,
  "viridi", 30L, 159L, 136L,
  "viridi", 30L, 160L, 135L,
  "viridi", 31L, 161L, 135L,
  "viridi", 31L, 162L, 134L,
  "viridi", 31L, 163L, 134L,
  "viridi", 32L, 164L, 133L,
  "viridi", 32L, 165L, 133L,
  "viridi", 33L, 166L, 133L,
  "viridi", 33L, 167L, 132L,
  "viridi", 34L, 167L, 132L,
  "viridi", 35L, 168L, 131L,
  "viridi", 35L, 169L, 130L,
  "viridi", 36L, 170L, 130L,
  "viridi", 37L, 171L, 129L,
  "viridi", 38L, 172L, 129L,
  "viridi", 39L, 173L, 128L,
  "viridi", 40L, 174L, 127L,
  "viridi", 41L, 175L, 127L,
  "viridi", 42L, 176L, 126L,
  "viridi", 43L, 177L, 125L,
  "viridi", 44L, 177L, 125L,
  "viridi", 46L, 178L, 124L,
  "viridi", 47L, 179L, 123L,
  "viridi", 48L, 180L, 122L,
  "viridi", 50L, 181L, 122L,
  "viridi", 51L, 182L, 121L,
  "viridi", 53L, 183L, 120L,
  "viridi", 54L, 184L, 119L,
  "viridi", 56L, 185L, 118L,
  "viridi", 57L, 185L, 118L,
  "viridi", 59L, 186L, 117L,
  "viridi", 61L, 187L, 116L,
  "viridi", 62L, 188L, 115L,
  "viridi", 64L, 189L, 114L,
  "viridi", 66L, 190L, 113L,
  "viridi", 68L, 190L, 112L,
  "viridi", 69L, 191L, 111L,
  "viridi", 71L, 192L, 110L,
  "viridi", 73L, 193L, 109L,
  "viridi", 75L, 194L, 108L,
  "viridi", 77L, 194L, 107L,
  "viridi", 79L, 195L, 105L,
  "viridi", 81L, 196L, 104L,
  "viridi", 83L, 197L, 103L,
  "viridi", 85L, 198L, 102L,
  "viridi", 87L, 198L, 101L,
  "viridi", 89L, 199L, 100L,
  "viridi", 91L, 200L, 98L,
  "viridi", 94L, 201L, 97L,
  "viridi", 96L, 201L, 96L,
  "viridi", 98L, 202L, 95L,
  "viridi", 100L, 203L, 93L,
  "viridi", 103L, 204L, 92L,
  "viridi", 105L, 204L, 91L,
  "viridi", 107L, 205L, 89L,
  "viridi", 109L, 206L, 88L,
  "viridi", 112L, 206L, 86L,
  "viridi", 114L, 207L, 85L,
  "viridi", 116L, 208L, 84L,
  "viridi", 119L, 208L, 82L,
  "viridi", 121L, 209L, 81L,
  "viridi", 124L, 210L, 79L,
  "viridi", 126L, 210L, 78L,
  "viridi", 129L, 211L, 76L,
  "viridi", 131L, 211L, 75L,
  "viridi", 134L, 212L, 73L,
  "viridi", 136L, 213L, 71L,
  "viridi", 139L, 213L, 70L,
  "viridi", 141L, 214L, 68L,
  "viridi", 144L, 214L, 67L,
  "viridi", 146L, 215L, 65L,
  "viridi", 149L, 215L, 63L,
  "viridi", 151L, 216L, 62L,
  "viridi", 154L, 216L, 60L,
  "viridi", 157L, 217L, 58L,
  "viridi", 159L, 217L, 56L,
  "viridi", 162L, 218L, 55L,
  "viridi", 165L, 218L, 53L,
  "viridi", 167L, 219L, 51L,
  "viridi", 170L, 219L, 50L,
  "viridi", 173L, 220L, 48L,
  "viridi", 175L, 220L, 46L,
  "viridi", 178L, 221L, 44L,
  "viridi", 181L, 221L, 43L,
  "viridi", 183L, 221L, 41L,
  "viridi", 186L, 222L, 39L,
  "viridi", 189L, 222L, 38L,
  "viridi", 191L, 223L, 36L,
  "viridi", 194L, 223L, 34L,
  "viridi", 197L, 223L, 33L,
  "viridi", 199L, 224L, 31L,
  "viridi", 202L, 224L, 30L,
  "viridi", 205L, 224L, 29L,
  "viridi", 207L, 225L, 28L,
  "viridi", 210L, 225L, 27L,
  "viridi", 212L, 225L, 26L,
  "viridi", 215L, 226L, 25L,
  "viridi", 218L, 226L, 24L,
  "viridi", 220L, 226L, 24L,
  "viridi", 223L, 227L, 24L,
  "viridi", 225L, 227L, 24L,
  "viridi", 228L, 227L, 24L,
  "viridi", 231L, 228L, 25L,
  "viridi", 233L, 228L, 25L,
  "viridi", 236L, 228L, 26L,
  "viridi", 238L, 229L, 27L,
  "viridi", 241L, 229L, 28L,
  "viridi", 243L, 229L, 30L,
  "viridi", 246L, 230L, 31L,
  "viridi", 248L, 230L, 33L,
  "viridi", 250L, 230L, 34L,
  "viridi", 253L, 231L, 36L,
  "gn_yl", 0L, 104L, 55L,
  "gn_yl", 49L, 163L, 84L,
  "gn_yl", 120L, 198L, 121L,
  "gn_yl", 173L, 221L, 142L,
  "gn_yl", 217L, 240L, 163L,
  "gn_yl", 255L, 255L, 204L,
  "pi_y_g", 197L, 27L, 125L,
  "pi_y_g", 222L, 119L, 174L,
  "pi_y_g", 241L, 182L, 218L,
  "pi_y_g", 253L, 224L, 239L,
  "pi_y_g", 247L, 247L, 247L,
  "pi_y_g", 230L, 245L, 208L,
  "pi_y_g", 184L, 225L, 134L,
  "pi_y_g", 127L, 188L, 65L,
  "pi_y_g", 77L, 146L, 33L,
  "bl_yl_rd", 69L, 117L, 180L,
  "bl_yl_rd", 116L, 173L, 209L,
  "bl_yl_rd", 171L, 217L, 233L,
  "bl_yl_rd", 224L, 243L, 248L,
  "bl_yl_rd", 255L, 255L, 191L,
  "bl_yl_rd", 254L, 224L, 144L,
  "bl_yl_rd", 253L, 174L, 97L,
  "bl_yl_rd", 244L, 109L, 67L,
  "bl_yl_rd", 215L, 48L, 39L,
  "deep", 254L, 254L, 215L,
  "deep", 253L, 254L, 213L,
  "deep", 252L, 253L, 210L,
  "deep", 251L, 253L, 208L,
  "deep", 249L, 253L, 205L,
  "deep", 248L, 252L, 203L,
  "deep", 247L, 252L, 200L,
  "deep", 246L, 251L, 198L,
  "deep", 245L, 251L, 195L,
  "deep", 244L, 251L, 194L,
  "deep", 243L, 250L, 190L,
  "deep", 242L, 250L, 189L,
  "deep", 240L, 249L, 185L,
  "deep", 240L, 249L, 184L,
  "deep", 238L, 248L, 180L,
  "deep", 238L, 248L, 179L,
  "deep", 235L, 247L, 177L,
  "deep", 233L, 246L, 177L,
  "deep", 232L, 246L, 177L,
  "deep", 228L, 244L, 177L,
  "deep", 226L, 243L, 177L,
  "deep", 223L, 242L, 178L,
  "deep", 222L, 242L, 178L,
  "deep", 218L, 240L, 178L,
  "deep", 216L, 239L, 178L,
  "deep", 214L, 239L, 178L,
  "deep", 213L, 238L, 178L,
  "deep", 209L, 237L, 179L,
  "deep", 207L, 236L, 179L,
  "deep", 204L, 235L, 179L,
  "deep", 203L, 234L, 179L,
  "deep", 199L, 233L, 179L,
  "deep", 196L, 231L, 180L,
  "deep", 191L, 230L, 180L,
  "deep", 187L, 228L, 181L,
  "deep", 182L, 226L, 181L,
  "deep", 178L, 224L, 182L,
  "deep", 175L, 223L, 182L,
  "deep", 169L, 221L, 182L,
  "deep", 164L, 219L, 183L,
  "deep", 160L, 217L, 183L,
  "deep", 155L, 216L, 184L,
  "deep", 151L, 214L, 184L,
  "deep", 146L, 212L, 185L,
  "deep", 141L, 210L, 185L,
  "deep", 139L, 209L, 185L,
  "deep", 132L, 207L, 186L,
  "deep", 128L, 205L, 186L,
  "deep", 124L, 204L, 187L,
  "deep", 120L, 202L, 187L,
  "deep", 116L, 201L, 188L,
  "deep", 112L, 199L, 189L,
  "deep", 108L, 198L, 189L,
  "deep", 106L, 197L, 189L,
  "deep", 100L, 195L, 190L,
  "deep", 97L, 193L, 191L,
  "deep", 93L, 192L, 191L,
  "deep", 89L, 191L, 192L,
  "deep", 85L, 189L, 193L,
  "deep", 81L, 188L, 193L,
  "deep", 77L, 186L, 194L,
  "deep", 75L, 185L, 194L,
  "deep", 69L, 183L, 195L,
  "deep", 65L, 182L, 195L,
  "deep", 63L, 180L, 195L,
  "deep", 61L, 177L, 195L,
  "deep", 58L, 175L, 195L,
  "deep", 56L, 173L, 195L,
  "deep", 54L, 170L, 194L,
  "deep", 52L, 168L, 194L,
  "deep", 49L, 166L, 194L,
  "deep", 47L, 164L, 194L,
  "deep", 45L, 161L, 193L,
  "deep", 42L, 159L, 193L,
  "deep", 40L, 157L, 193L,
  "deep", 39L, 155L, 193L,
  "deep", 36L, 152L, 192L,
  "deep", 33L, 150L, 192L,
  "deep", 31L, 147L, 192L,
  "deep", 29L, 145L, 192L,
  "deep", 29L, 142L, 190L,
  "deep", 29L, 139L, 189L,
  "deep", 29L, 135L, 187L,
  "deep", 30L, 132L, 186L,
  "deep", 30L, 129L, 184L,
  "deep", 30L, 126L, 183L,
  "deep", 31L, 123L, 181L,
  "deep", 31L, 119L, 180L,
  "deep", 31L, 116L, 178L,
  "deep", 32L, 113L, 177L,
  "deep", 32L, 110L, 175L,
  "deep", 32L, 108L, 174L,
  "deep", 33L, 103L, 172L,
  "deep", 33L, 100L, 171L,
  "deep", 33L, 97L, 169L,
  "deep", 33L, 94L, 168L,
  "deep", 34L, 91L, 166L,
  "deep", 34L, 89L, 165L,
  "deep", 34L, 86L, 164L,
  "deep", 34L, 83L, 163L,
  "deep", 34L, 81L, 161L,
  "deep", 35L, 78L, 160L,
  "deep", 35L, 75L, 159L,
  "deep", 35L, 73L, 158L,
  "deep", 35L, 70L, 156L,
  "deep", 35L, 67L, 155L,
  "deep", 36L, 65L, 154L,
  "deep", 36L, 64L, 153L,
  "deep", 36L, 60L, 151L,
  "deep", 36L, 57L, 150L,
  "deep", 36L, 54L, 149L,
  "deep", 36L, 52L, 148L,
  "deep", 35L, 50L, 144L,
  "deep", 33L, 49L, 140L,
  "deep", 31L, 47L, 136L,
  "deep", 29L, 46L, 133L,
  "deep", 28L, 44L, 129L,
  "deep", 26L, 43L, 125L,
  "deep", 24L, 41L, 121L,
  "deep", 22L, 40L, 118L,
  "deep", 20L, 39L, 114L,
  "deep", 18L, 37L, 110L,
  "deep", 17L, 36L, 106L,
  "deep", 16L, 35L, 104L,
  "deep", 13L, 33L, 99L,
  "deep", 11L, 31L, 95L,
  "deep", 9L, 30L, 91L,
  "deep", 8L, 28L, 87L
)

# Change name
whitebox_coltab <- whitebox_coltab %>%
  mutate(pal = if_else(pal == "high", "high_relief", pal))

# Make hex color
whitebox_coltab$hex <- rgb(whitebox_coltab$r,
  whitebox_coltab$g,
  whitebox_coltab$b,
  maxColorValue = 255
)

scales::show_col(whitebox_coltab$hex, labels = FALSE)


usethis::use_data(whitebox_coltab, overwrite = TRUE, internal = TRUE)
