% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_stats.R
\name{write_stats}
\alias{write_stats}
\title{Write a tidystats list to a file}
\usage{
write_stats(x, path, digits = 6)
}
\arguments{
\item{x}{A tidystats list.}

\item{path}{A string specifying the path or connection to write to.}

\item{digits}{The number of decimal places to use. The default is 6.}
}
\description{
\code{\link[=write_stats]{write_stats()}} writes a tidystats list to a .json file.
}
\examples{
# Conduct a statistical test
sleep_wide <- reshape(
  sleep,
  direction = "wide",
  idvar = "ID",
  timevar = "group",
  sep = "_"
)
sleep_test <- t.test(sleep_wide$extra_1, sleep_wide$extra_2, paired = TRUE)

# Create an empty list
statistics <- list()

# Add statistics to the list
statistics <- add_stats(statistics, sleep_test)

# Save the statistics to a file
dir <- tempdir()
write_stats(statistics, file.path(dir, "statistics.json"))

}
