% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-pull.R
\name{vars_pull}
\alias{vars_pull}
\title{Select variable}
\usage{
vars_pull(
  vars,
  var = -1,
  error_call = caller_env(),
  error_arg = caller_arg(var)
)
}
\arguments{
\item{vars}{A character vector of existing column names.}

\item{var}{A variable specified as:
\itemize{
\item a literal variable name
\item a positive integer, giving the position counting from the left
\item a negative integer, giving the position counting from the right.
}

The default returns the last column (on the assumption that's the
column you've created most recently).

This argument is taken by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names and column locations).}

\item{error_call}{The execution environment of a currently
running function, e.g. \code{caller_env()}. The function will be
mentioned in error messages as the source of the error. See the
\code{call} argument of \code{\link[rlang:abort]{abort()}} for more information.}

\item{error_arg}{An argument name as a string. This argument
will be mentioned in error messages as the input that is at the
origin of a problem.}
}
\value{
The selected column name as an unnamed string.
}
\description{
This function powers \code{\link[dplyr:pull]{dplyr::pull()}} and various functions of the
tidyr package. It is similar to \code{\link[=vars_select]{vars_select()}} but returns only
one column name and has slightly different semantics: it allows
negative numbers to select columns from the end.
}
\examples{
# It takes its argument by expression:
vars_pull(letters, c)

# Negative numbers select from the end:
vars_pull(letters, -3)

# You can unquote variables:
var <- 10
vars_pull(letters, !!var)
}
\seealso{
\code{\link[dplyr:pull]{dplyr::pull()}}, \code{\link[=vars_select]{vars_select()}}
}
\keyword{internal}
