% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.gets.R
\name{.fit.gets}
\alias{.fit.gets}
\title{General-to-specific regression for \code{tidyfit}}
\usage{
\method{.fit}{gets}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a general-to-specific (GETS) regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item \code{max.paths} \emph{(Number of paths to search)}
}

The function provides a wrapper for \code{gets::gets}. See \code{?gets} for more details.

\strong{Implementation}

Print output is suppressed by default. Use 'print.searchinfo = TRUE' for print output.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("gets", Return ~ `Mkt-RF` + HML + SMB, data)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("gets"), .mask = c("Date", "Industry"))
coef(fit)

}
\references{
Pretis F, Reade JJ, Sucarrat G (2018).
\emph{Automated General-to-Specific (GETS) Regression Modeling and Indicator Saturation for Outliers and Structural Breaks.}
Journal of Statistical Software 86(3), 1-44.
}
\seealso{
\code{\link{.fit.robust}}, \code{\link{.fit.glm}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
