% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.glmm.R
\name{.fit.glmm}
\alias{.fit.glmm}
\title{Generalized linear mixed-effects model for \code{tidyfit}}
\usage{
\method{.fit}{glmm}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a linear or logistic mixed-effects model (GLMM) on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}} and \code{\link{classify}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}

The function provides a wrapper for \code{lme4::glmer}. See \code{?glmer} for more details.

\strong{Implementation}

\emph{No implementation notes}
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns
data$Return <- ifelse(data$Return > 0, 1, 0)

# Estimate model with random effects
fit <- classify(data, Return ~ CMA + (CMA | Industry), logit = m("glmm"),
                .mask = "Date")
fit


}
\references{
Douglas Bates, Martin Maechler, Ben Bolker, Steve Walker (2015). Fitting Linear Mixed-Effects Models Using lme4. Journal of Statistical Software, 67(1), 1-48. doi:10.18637/jss.v067.i01.
}
\seealso{
\code{\link{.fit.glm}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
