% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.bma.R
\name{.model.bma}
\alias{.model.bma}
\title{Bayesian model averaging for \code{tidyfit}}
\usage{
\method{.model}{bma}(self, data = NULL)
}
\arguments{
\item{self}{a 'tidyFit' R6 class.}

\item{data}{a data frame, data frame extension (e.g. a tibble), or a lazy data frame (e.g. from dbplyr or dtplyr).}
}
\value{
A fitted 'tidyFit' class model.
}
\description{
Fits a Bayesian model averaging regression on a 'tidyFit' \code{R6} class. The function can be used with \code{\link{regress}}.
}
\details{
\strong{Hyperparameters:}

\emph{None. Cross validation not applicable.}

\strong{Important method arguments (passed to \code{\link{m}})}
\itemize{
\item \code{iter} (\emph{number of iteration draws})
\item \code{mcmc} (\emph{model sampler used (default 'bd')})
}

The function provides a wrapper for \code{BMS::bms}. See \code{?bms} for more details.

\strong{Implementation}

The underlying function automatically generates plotting output, which is not suppressed.

Use \code{coef(fit)} to obtain posterior mean, standard deviation as well as posterior inclusion probabilities for the features.
}
\examples{
# Load data
data <- tidyfit::Factor_Industry_Returns

# Stand-alone function
fit <- m("bma", Return ~ `Mkt-RF` + HML + SMB + RMW + CMA, data)
fit

# Within 'regress' function
fit <- regress(data, Return ~ ., m("bma"), .mask = c("Date", "Industry"))
coef(fit)

}
\references{
Feldkircher, M. and S. Zeugner (2015).
\emph{Bayesian Model Averaging Employing Fixed and Flexible Priors: The BMS Package for R},
Journal of Statistical Software 68(4).
}
\seealso{
\code{\link{.model.bayes}} and \code{\link{m}} methods
}
\author{
Johann Pfitzinger
}
