% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metric-sse.R
\name{sse_total}
\alias{sse_total}
\alias{sse_total.cluster_spec}
\alias{sse_total.cluster_fit}
\alias{sse_total.workflow}
\alias{sse_total_vec}
\title{Compute the total sum of squares}
\usage{
sse_total(object, ...)

\method{sse_total}{cluster_spec}(object, ...)

\method{sse_total}{cluster_fit}(object, new_data = NULL, dist_fun = NULL, ...)

\method{sse_total}{workflow}(object, new_data = NULL, dist_fun = NULL, ...)

sse_total_vec(object, new_data = NULL, dist_fun = Rfast::dista, ...)
}
\arguments{
\item{object}{A fitted kmeans tidyclust model}

\item{...}{Other arguments passed to methods.}

\item{new_data}{A dataset to predict on.  If \code{NULL}, uses trained clustering.}

\item{dist_fun}{A function for calculating distances to centroids.  Defaults
to Euclidean distance on processed data.}
}
\value{
A tibble with 3 columns; \code{.metric}, \code{.estimator}, and \code{.estimate}.
}
\description{
Compute the total sum of squares
}
\examples{
kmeans_spec <- k_means(num_clusters = 5) \%>\%
  set_engine("stats")

kmeans_fit <- fit(kmeans_spec, ~., mtcars)

sse_total(kmeans_fit)

sse_total_vec(kmeans_fit)
}
\seealso{
Other cluster metric: 
\code{\link{silhouette_avg}()},
\code{\link{sse_ratio}()},
\code{\link{sse_within_total}()}
}
\concept{cluster metric}
