% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/k_means_clustMixType.R
\name{details_k_means_clustMixType}
\alias{details_k_means_clustMixType}
\title{K-means via clustMixType}
\description{
\code{\link[=k_means]{k_means()}} creates K-prototypes model. A K-prototypes is the middle ground
between a K-means and K-modes model, in the sense that it can be used with
data that contains both numeric and categorical predictors.
}
\details{
Both numeric and categorical predictors are requires for this engine.

For this engine, there is a single mode: partition
\subsection{Tuning Parameters}{

This model has 1 tuning parameters:
\itemize{
\item \code{num_clusters}: # Clusters (type: integer, default: no default)
}
}

\subsection{Translation from tidyclust to the original package (partition)}{

\if{html}{\out{<div class="sourceCode r">}}\preformatted{k_means(num_clusters = integer(1)) \%>\% 
  set_engine("clustMixType") \%>\% 
  set_mode("partition") \%>\% 
  translate_tidyclust()
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## K Means Cluster Specification (partition)
## 
## Main Arguments:
##   num_clusters = integer(1)
## 
## Computational engine: clustMixType 
## 
## Model fit template:
## tidyclust::.k_means_fit_clustMixType(x = missing_arg(), k = missing_arg(), 
##     keep.data = missing_arg(), k = integer(1), keep.data = TRUE, 
##     verbose = FALSE)
}\if{html}{\out{</div>}}
}

\subsection{Preprocessing requirements}{

Both categorical and numeric predictors are required.
}

\subsection{References}{
\itemize{
\item Szepannek, G. (2018): clustMixType: User-Friendly Clustering of
Mixed-Type Data in R, The R Journal 10/2, 200-208,
\url{doi:10.32614/RJ-2018-048}.
\item Aschenbruck, R., Szepannek, G., Wilhelm, A. (2022): Imputation
Strategies for Clustering Mixed‑Type Data with Missing Values, Journal
of Classification, \url{doi:10.1007/s00357-022-09422-y}.
\item Z.Huang (1998): Extensions to the k-Means Algorithm for Clustering
Large Data Sets with Categorical Variables, Data Mining and Knowledge
Discovery 2, 283-304.
}
}
}
\keyword{internal}
