#' Caregiver Compass Data
#'
#' These simulated data are based on a study by Dijenborgh, Swildens,
#' and Zegwaard on different types of caregivers among those
#' providing informal care to outpatients receiving mental healthcare.
#'
#' \tabular{lll}{
#'   \strong{burdened} \tab \code{numeric} \tab How strongly is the caregiver's life affected by their responsibilities? Scale score, based on 15 items with Likert-type response options. Example: "I never feel free of responsibilities"\cr
#'   \strong{trapped} \tab \code{numeric} \tab Caregiver's cognitions regarding freedom of choice. Scale score, based on 3 items with Likert-type response options. Example: "I feel trapped by the affliction of my charge"\cr
#'   \strong{negaffect} \tab \code{numeric} \tab Different types of negative emotions experienced by the caregiver. Scale score, based on 9 items with Likert-type response options. Example: "I feel angry in the relationship with my charge"\cr
#'   \strong{loneliness} \tab \code{numeric} \tab Caregiver's perceived loneliness. Scale score, based on 11 items with Likert-type response options. Example: "I miss having people around"\cr
#'   \strong{sex} \tab \code{factor} \tab Caregiver sex\cr
#'   \strong{sexpatient} \tab \code{factor} \tab Sex of the patient\cr
#'   \strong{cohabiting} \tab \code{factor} \tab Whether or not the caregiver cohabits with the patient\cr
#'   \strong{distance} \tab \code{numeric} \tab Travel time in minutes for the caregiver to reach the patient\cr
#'   \strong{freqvisit} \tab \code{ordered} \tab Ordinal variable, indicating frequency of visits\cr
#'   \strong{relationship} \tab \code{factor} \tab Type of relationship of patient with caregiver
#' }
#' @docType data
#' @keywords datasets
#' @name zegwaard_carecompass
#' @usage data(zegwaard_carecompass)
# @references Alkema, L. M., Van Lissa, C. J., Kooi, M., & Koelmans, A. A. (2022).
# Maximizing Realism: Mapping Plastic Particles at the Ocean Surface Using
# Mixtures of Normal Distributions. Environmental Science & Technology,
# 56(22), 15552-15562.
# \doi{10.1021/acs.est.2c03559}
#' @format A data frame with 513 rows and 10 variables.
NULL
