# tidySEM 0.2.5

* Add reference to best practices paper, <DOI:10.1080/10705511.2023.2250920>
* Include vignettes corresponding to the appendices of that paper
* Correct implementation of `lr_lmr()` using `nonnest2::vuongtest()`

# tidySEM 0.2.4

* Update maintainer email address
* Fixed bug in `plot_profiles()` when covariances are free
* Improved starting values for latent class analysis
* Documentation incorrectly referred to `data_mixture_ordinal`, instead of
  `data_mix_ordinal`
* Added legend to `plot_probs()`
* Added `np_ratio` and `np_local` to `table_fit()` output for mixture models
* Reimplement `BLRT()` to avoid slow OpenMx implementation
* Add functions `lr_test()` and `lr_lmr()`

# tidySEM 0.2.3

* Fix Issue #45 , argument `label` was not passed correctly to `get_nodes()` and
  `get_edges()` in `graph_sem()` and `prepare_graph()`
* Fix Issue #47, list of character vectors was not properly converted to an
  mxModel

# tidySEM 0.2.2

* table_fit() now reports information criteria with parameter penalty
* BCH() now accepts an MxModel as auxiliary model
* Prevent Mplus tests from throwing error on CRAN

# tidySEM 0.2.1

* Fix CRAN check errors related to OpenMx
* Add mx_lca(), a dedicated function for estimating mixture models with
  ordinal/binary data that avoids convergence problems when using mx_mixture()
  with those data types
* Add table_prob() to tabulate category probabilities for models with ordinal
  indicators
* Add plot_prob() to plot category probabilities for models with ordinal
  indicators

# tidySEM 0.2.0

* Add functions for OpenMx
* Add functions for mixture models
* Add methods for chisq_sb()
* Minor bugfixes and feature enhancements

# tidySEM 0.1.9

* Removed LazyData entry from DESCRIPTION (no data included in package)
* Add methods for mplusObjects
* Fixed bug where nodes from multilevel models were incorrectly merged, due to
  lack of within-level intercepts
* Fixed bug where get_layout did not work for multilevel models because it used
  table_results() instead of get_edges()
* Fixed bug in create_scales

# tidySEM 0.1.8

* Fixed bug where table_results() was broken by renaming 'label' column to
  'mplus_label'

# tidySEM 0.1.7

* Fixed several bugs in plotting, caused by multiple columns called "label" 
  generated by mplus and lavaan, which overlap with the "label" column used for
  plotting. Renamed other "label" columns to "mplus_label" and "lavaan_label"
* Fixed bug where arguments were not passed from prepare_graph() and graph_sem()
  to get_nodes() and get_edges(), e.g., digits was not passed on
* Fixed bug where linetype did not work when using a mix of numeric (e.g., 1) 
  and character (e.g., "dashed") values
* Node labels can now be customized just like edge labels
* Added convenience functions to conditionally customize graphs based on
  if_edit(), e.g.: sig_colour(plot, "green")
* Improved functionality of edit_graph() methods
* Added wrappers for edit_graph(): edit_edges() and edit_nodes()
* graph_sem(fix_coord = TRUE) now works for multi-group models

# tidySEM 0.1.6

* Fixed another faulty URI in README.md

# tidySEM 0.1.5

* Fixed URI in README.md

# tidySEM 0.1.4

* Fixed bug in direction of arrow for curved paths
* Support argument "color" in addition to "colour"
* The "label" argument of get_edges() and get_nodes() now accepts an expression,
  that is evaluated in the context of a data.frame generated by table_results().
  This allows users to specify compound labels.
  

# tidySEM 0.1.3

* Changed arguments for graph_sem.lavaan and graph_sem.mplus.model; these gain
  arguments "label", "edges", "layout", and "nodes",
  which apply get_edges(), get_layout(), and get_nodes() to the model argument,
  respectively, passing on the "label" argument to get_edges() and get_nodes().
* The default label has been changed to "est_sig" throughout the package. Some
  functions used "est_sig_std" instead.
* Minor bugfixes
* Fix bug where > 26 nodes resulted in wrong plot

# tidySEM 0.1.2

* create_scales() no longer writes .csv files
* add_paths() now relies on lavaanify(lavParseModelString()), uses the lavaan
  parameter table, and accepts all arguments of lavaanify(), with default
  arguments same as sem() and cfa()
* measurement() uses add_paths() for consistency
* `graph_sem.lavaan()` and `graph_sem.mplus.model()` gain an argument
  `label = "est_sig"`, so users can easily select custom labels.
* New vignette about SEM plotting conventions.
* `graph_sem()` adds empty labels for nodes without a mean; in version 0.1.1,
  such nodes were displayed without any node label.

# tidySEM 0.1.1

* Addressed comment by CRAN maintainer Jelena Saf
* Minor bug fixes

# tidySEM 0.1.0

* First CRAN release.
