% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thr_est.R
\name{thr_est}
\alias{thr_est}
\title{Threshold Estimation}
\usage{
thr_est(
  df,
  yi,
  xi,
  qi,
  h,
  test.pvalue,
  var.names = colnames(df),
  conf2 = 0.8,
  nonpar = 2,
  graph = TRUE,
  signif.level = "stars",
  inf.crit = FALSE,
  digits = 3,
  integer.digits = NULL,
  digits.thr = digits,
  header = NULL,
  output.short = FALSE,
  signif.legend = TRUE
)
}
\arguments{
\item{df}{Data frame.}

\item{yi}{Integer or character; index or column name of dependent (y)
variable in \code{df}.}

\item{xi}{Integer or character vector; indexes or column names of
independent (x) variables in \code{df}.}

\item{qi}{Integer or character; index or column name of threshold (q)
variable in \code{df}.}

\item{h}{Integer; heteroskedasticity indicator.
Set \code{h = 0} to impose homoskedasticity assumption;
set \code{h = 1} to use White-correction for heteroskedasticity.}

\item{test.pvalue}{Numeric; p-value of the threshold test returned by
\code{\link{thr_test_hom}} or \code{\link{thr_test_hom}}.}

\item{var.names}{Character vector; variable names with
\code{length(var.names) == ncol(df)} corresponding to columns in
\code{df} to be used in threshold regression table.
Default is \code{colnames(df)}.}

\item{conf2}{Numeric; confidence level for first step of two-step
confidence regions for regression parameters. Default is \code{conf2 = .8}.}

\item{nonpar}{Integer; indicator for non-parametric method used to estimate
nuisance scale in the presence of heteroskedasticity
(only relevant if \code{h = 1}).
Set \code{nonpar = 1} to estimate regressions using a quadratic;
set \code{nonpar= 2} (default) to estimate regressions using an
Epanechnikov kernel with automatic bandwidth.}

\item{graph}{Logical; graph indicator.
Set \code{TRUE} (default) to view the graph of the concentrated
likelihood in gamma;
set \code{FALSE} otherwise.}

\item{signif.level}{Character; indicator for notation of statistical
significance levels.
Set \code{signif.level = "stars"} (default) to use stars:
\eqn{*p < 0.1}, \eqn{**p < 0.05}, \eqn{***p < 0.01}.
Set \code{signif.level = "colors"} to use red and blue tones for
statistically significant positive and negative estimates, respectively.
(see \strong{Note} for LaTeX specification of red and blue tones.)}

\item{inf.crit}{Logical; if \code{TRUE}, information criteria (AIC, BIC, HQC)
for each regime are shown in threshold regression table. Default is
\code{FALSE}.}

\item{digits}{Integer; number of decimal places to be used for estimated
coefficients in threshold regression table. Default is \code{digits = 3}.
(Will be used in \code{format(round(x, digits = digits), nsmall = digits)},
see \code{\link{format}}, \code{\link{round}}.)}

\item{integer.digits}{Integer; number of integer digits (i.e. digits before
the decimal point) to be used for estimated coefficients in threshold
regression table. If \code{NULL} (default), maximum value will be inquired.}

\item{digits.thr}{Integer; number of decimal places to be used for threshold
estimate in threshold regression table. Default is
\code{digits.thr = digits}. (See \code{digits} for usage.)}

\item{header}{Character; header to be used in threshold regression table.}

\item{output.short}{Logical; if \code{FALSE} (default), full output is printed.
If \code{TRUE}, only threshold regression table is printed.}

\item{signif.legend}{Logical; if \code{TRUE} (default), legend of
significance levels is printed below threshold regression table.}
}
\value{
Least squares estimate of threshold parameter. Output is printed to
    console unless redirected to file with \code{\link{sink}} (see examples).
}
\description{
Computes estimates, standard errors, and confidence intervals of parameters
in the threshold regression model.
}
\details{
Do not include a constant in the independent variables;
        the function automatically adds an intercept to the regression.
}
\note{
\enumerate{
    \item Load these packages in LaTeX file:
    \code{
    \\usepackage{booktabs} \\usepackage[table]{xcolor} \\usepackage{siunitx}}.
    \item If \code{signif.level = "colors"}, add these commands in LaTeX file
          to obtain red and blue tones:
    \code{
    \\newcommand{\\RedA}{red} \\newcommand{\\RedB}{red!60}
    \\newcommand{\\RedC}{red!30} \\newcommand{\\BlueA}{blue!75}
    \\newcommand{\\BlueB}{blue!55} \\newcommand{\\BlueC}{blue!30}}.
    }
}
\examples{
\donttest{
## Performs part of the empirical work reported in Hansen (2000)
data <- dur_john
test <- thr_test_het(data, 1, 2:5, 6)

qhat <- thr_est(data, 1, 2:5, 6, 1, test$p_value)
qhat
}

}
\references{
Hansen, B. E. (2000). Sample splitting and threshold estimation.
    \emph{Econometrica}, 68(3):575--603.
    \url{https://doi.org/10.1111/1468-0262.00124}.
    \url{https://www.ssc.wisc.edu/~bhansen/papers/ecnmt_00.pdf}.
}
\seealso{
\code{\link{thr_test_hom}} and \code{\link{thr_test_het}} for threshold
    tests under homoskedasticity and heteroskedasticity, respectively.
}
\author{
Marcel Kremer, \email{marcel.kremer@uni-due.de}

Bruce E. Hansen, \email{behansen@wisc.edu}
}
\keyword{htest}
\keyword{models}
\keyword{ts}
