% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delaunay.R
\name{plotDelaunay3D}
\alias{plotDelaunay3D}
\title{Plot 3D Delaunay tessellation}
\usage{
plotDelaunay3D(
  tessellation,
  color = "distinct",
  distinctArgs = list(seedcolors = c("#ff0000", "#00ff00", "#0000ff")),
  randomArgs = list(hue = "random", luminosity = "bright"),
  alpha = 0.3,
  exteriorEdgesAsTubes = FALSE,
  tubeRadius,
  tubeColor
)
}
\arguments{
\item{tessellation}{the output of \code{\link{delaunay}}}

\item{color}{controls the filling colors of the tetrahedra, either
\code{FALSE} for no color, \code{"random"} to use
\code{\link[colorsGen]{randomColor}}, or \code{"distinct"} to use
\code{\link[Polychrome]{createPalette}}}

\item{distinctArgs}{if \code{color = "distinct"}, a list of arguments
passed to \code{\link[Polychrome]{createPalette}}}

\item{randomArgs}{if \code{color = "random"}, a list of arguments passed
to \code{\link[colorsGen]{randomColor}}}

\item{alpha}{opacity, number between 0 and 1}

\item{exteriorEdgesAsTubes}{Boolean, whether to plot the exterior edges
as tubes; in order to use this feature, you need to set
\code{exteriorEdges = TRUE} in the \code{\link{delaunay}} function}

\item{tubeRadius}{if \code{exteriorEdgesAsTubes = TRUE}, the radius of
the tubes}

\item{tubeColor}{if \code{exteriorEdgesAsTubes = TRUE}, the color of
the tubes}
}
\value{
No value, just renders a 3D plot.
}
\description{
Plot a 3D Delaunay tessellation with \strong{rgl}.
}
\examples{
library(tessellation)
pts <- rbind(
  c(-5, -5,  16),
  c(-5,  8,   3),
  c(4,  -1,   3),
  c(4,  -5,   7),
  c(4,  -1, -10),
  c(4,  -5, -10),
  c(-5,  8, -10),
  c(-5, -5, -10)
)
tess <- delaunay(pts)
library(rgl)
open3d(windowRect = c(50, 50, 562, 562))
plotDelaunay3D(tess, color = "random")
\donttest{open3d(windowRect = c(50, 50, 562, 562))
plotDelaunay3D(
  tess, exteriorEdgesAsTubes = TRUE, tubeRadius = 0.3, tubeColor = "yellow"
)}
}
