% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_aws.R
\name{tar_resources_aws}
\alias{tar_resources_aws}
\title{Target resources: Amazon Web Services (AWS) S3 storage}
\usage{
tar_resources_aws(
  bucket = targets::tar_option_get("resources")$aws$bucket,
  prefix = targets::tar_option_get("resources")$aws$prefix,
  region = targets::tar_option_get("resources")$aws$region,
  part_size = targets::tar_option_get("resources")$aws$part_size,
  endpoint = targets::tar_option_get("resources")$aws$endpoint,
  ...
)
}
\arguments{
\item{bucket}{Character of length 1, name of an existing
bucket to upload and download the return values
of the affected targets during the pipeline.}

\item{prefix}{Character of length 1, "directory path"
in the bucket where the target return values are stored.
Defaults to \code{targets::tar_path_objects_dir_cloud()}.}

\item{region}{Character of length 1, AWS region containing the S3 bucket.
Set to \code{NULL} to use the default region.}

\item{part_size}{Positive numeric of length 1, number of bytes
for each part of a multipart upload. (Except the last part,
which is the remainder.) In a multipart upload, each part
must be at least 5 MB. The default value of the \code{part_size}
argument is \code{5 * (2 ^ 20)}.}

\item{endpoint}{Character of length 1, URL endpoint for S3 storage.
Defaults to the Amazon AWS endpoint if \code{NULL}. Example:
To use the S3 protocol with Google Cloud Storage,
set \code{endpoint = "https://storage.googleapis.com"}
and \code{region = "auto"}. Also make sure to create
HMAC access keys in the Google Cloud Storage console
(under Settings => Interoperability) and set the
\code{AWS_ACCESS_KEY_ID} and \code{AWS_SECRET_ACCESS_KEY} environment
variables accordingly. After that, you should be able to use
S3 storage formats with Google Cloud storage buckets.
There is one limitation, however: even if your bucket has
object versioning turned on, \code{targets} may fail to record object
versions. Google Cloud Storage in particular has this
incompatibility.}

\item{...}{Named arguments to functions in \code{paws::s3()} to manage
S3 storage. The documentation of these specific functions
is linked from \url{https://paws-r.github.io/docs/s3/}.
The configurable functions themselves are:
\itemize{
\item \code{paws::s3()$head_object()}
\item \code{paws::s3()$get_object()}
\item \code{paws::s3()$delete_object()}
\item \code{paws::s3()$put_object()}
\item \code{paws::s3()$create_multipart_upload()}
\item \code{paws::s3()$abort_multipart_upload()}
\item \code{paws::s3()$complete_multipart_upload()}
\item \code{paws::s3()$upload_part()}
The named arguments in \code{...} must not be any of
\code{"bucket"}, \code{"Bucket"}, \code{"key"}, \code{"Key"},
\code{"prefix"}, \code{"region"}, \code{"part_size"}, \code{"endpoint"},
\code{"version"}, \code{"VersionId"}, \code{"body"}, \code{"Body"},
\code{"metadata"}, \code{"Metadata"}, \code{"UploadId"}, \code{"MultipartUpload"},
or \code{"PartNumber"}.
}}
}
\value{
Object of class \code{"tar_resources_aws"}, to be supplied
to the \code{aws} argument of \code{tar_resources()}.
}
\description{
Create the \code{aws} argument of \code{tar_resources()}
to specify optional settings to AWS for
\code{tar_target(..., repository = "aws")}.
See the \code{format} argument of \code{\link[=tar_target]{tar_target()}} for details.
}
\details{
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.

In \code{targets} version 0.12.2 and above, resources are inherited one-by-one
in nested fashion from \code{tar_option_get("resources")}.
For example, suppose you set
\code{tar_option_set(resources = tar_resources(aws = my_aws))},
where \code{my_aws} equals \code{tar_resources_aws(bucket = "x", prefix = "y")}.
Then, \verb{tar_target(data, get_data()} will have bucket \code{"x"} and
prefix \code{"y"}. In addition, if \code{new_resources} equals
\verb{tar_resources(aws = tar_resources_aws(bucket = "z")))}, then
\code{tar_target(data, get_data(), resources = new_resources)}
will use the new bucket \code{"z"}, but it will still use the prefix \code{"y"}
supplied through \code{tar_option_set()}. (In \code{targets} 0.12.1 and below,
options like \code{prefix} do not carry over from \code{tar_option_set()} if you
supply non-default resources to \code{tar_target()}.)
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name,
  command(),
  format = "qs",
  repository = "aws",
  resources = tar_resources(
    aws = tar_resources_aws(bucket = "yourbucketname"),
    qs = tar_resources_qs(preset = "fast")
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_gcp}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_url}()},
\code{\link{tar_resources}()}
}
\concept{resources}
