% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewGelfandTsetlin.R
\name{skewGelfandTsetlinPatterns}
\alias{skewGelfandTsetlinPatterns}
\title{Skew Gelfand-Tsetlin patterns}
\usage{
skewGelfandTsetlinPatterns(lambda, mu, weight)
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition: 
\code{lambda} is the outer partition and \code{mu} is the inner partition 
(so \code{mu} must be a subpartition of \code{lambda}); \code{lambda}
will be the last row of the generated Gelfand-Tsetlin patterns and 
\code{mu} will be their first row}

\item{weight}{integer vector; this vector will be the 
differences of the row sums of the generated Gelfand-Tsetlin patterns; 
consequently, there will be no generated Gelfand-Tsetlin pattern unless 
the sum of \code{weight} equals the difference between the sum of 
\code{lambda} and the sum of \code{mu}}
}
\value{
A list of matrices with non-negative integer entries. The number 
  of columns of these matrices is the length of \code{lambda} and the 
  number of rows of these matrices is one plus the length of \code{weight}.
}
\description{
Enumeration of Gelfand-Tsetlin patterns defined by a 
  given skew partition and a given weight.
}
\examples{
skewGelfandTsetlinPatterns(c(3, 1, 1), c(2), c(1, 1, 1))
}
\seealso{
\code{\link{GelfandTsetlinPatterns}}.
}
