% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyph.fr-data.R
\docType{data}
\name{hyph.fr}
\alias{hyph.fr}
\title{Hyphenation patterns for French}
\format{The \code{pattern} slot of each hyphenation pattern object has three colums:
   \describe{
     \item{\code{orig}}{The original pattern in patgen style format.}
     \item{\code{char}}{Only the character elements of the pattern which can be matched to parts of an actual word.}
     \item{\code{nums}}{A code of digits defining the possibility to split syllables at respective places in this pattern.}
   }}
\source{
The patterns (as they are present in the \code{"orig"} column described above) were originally provided
by the LaTeX developers[1], under the terms of the LaTeX Project Public License[2].
Refer to Liang (1983) for a detailed explaination.
From these original patterns the values in the remaining columns were created using
\code{\link[sylly:read.hyph.pat]{read.hyph.pat}}.

In case any changes to the patterns were necessary to be used in this package, they are
documented in the ChangeLog for the sources package. The unchanged original patterns can be found under [1].
}
\usage{
hyph.fr
}
\description{
Hyphenation patterns for French to be used by \code{\link[sylly:hyphen]{hyphen}}.
These data objects are not really intended to be used directly, but rather to be consulted
by the \code{hyphen()} function without further user interaction.
}
\examples{
\dontrun{
library(sylly.fr)
sampleText <- c("c'est","un","exemple","assez","stupide")
hyphen(sampleText, hyph.pattern="fr")
}
}
\references{
Liang, F.M. (1983). \emph{Word Hy-phen-a-tion by Com-put-er}.
  Dissertation, Stanford University, Dept. of Computer Science.

[1] \url{http://tug.ctan.org/tex-archive/language/hyph-utf8/tex/generic/hyph-utf8/patterns/}

[2] \url{http://www.ctan.org/tex-archive/macros/latex/base/lppl.txt}
}
\seealso{
\code{\link[sylly:read.hyph.pat]{read.hyph.pat}},
   \code{\link[sylly:manage.hyph.pat]{manage.hyph.pat}}
}
\keyword{datasets}
