Dynamically Generate Documentation from a 'Swagger' Compliant API
================

[![CRAN\_Status\_Badge](https://www.r-pkg.org/badges/version/swagger)](https://cran.r-project.org/package=swagger)
[![Travis-CI Build Status](https://travis-ci.org/rstudio/swagger.svg?branch=master)](https://travis-ci.org/rstudio/swagger)

Swagger is a collection of HTML, JavaScript, and CSS assets that dynamically generate beautiful documentation from a Swagger-compliant API.

The main purpose of this package is to enable package authors to create APIs that are compatible with [swagger.io](https://swagger.io/) and [openapis.org](https://www.openapis.org/).

Package authors providing web interfaces can serve the static files from `swagger_path()` using [httpuv](https://github.com/rstudio/httpuv) or [fiery](https://github.com/thomasp85/fiery). As a start, we can also browse them by running:

``` r
library(swagger)
browseURL(swagger_index())
```

<img src="tools/readme/browse_swagger.png" width=450 />

To learn more about Swagger visit: [swagger.io/swagger-ui](https://swagger.io/swagger-ui/)
