% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svs.r
\name{dist_wrt}
\alias{dist_wrt}
\title{Compute Distances with respect to a certain Point}
\usage{
dist_wrt(x, wrt = NULL)
}
\arguments{
\item{x}{A numeric matrix (containing coordinates).}

\item{wrt}{A specification of the point with respect to which to compute all distances: can be either a vector or
the character label of one of the row levels in \code{x}. If \code{NULL} or \code{NA}, then the origin (i.e.
the point \code{c(0 , 0, 0,... )}) is taken as the value.}
}
\value{
A matrix (containing distances between the rows of \code{x} and \code{wrt}).
}
\description{
A function for computing (euclidean) distances with respect to a certain specified point.
}
\examples{
SndT_Fra <- read.table(system.file("extdata", "SndT_Fra.txt", package = "svs"),
   header = TRUE, sep = "\t", quote = "\"", encoding = "UTF-8",
   stringsAsFactors = FALSE)
sca_SndT_Fra <- fast_sca(SndT_Fra)
dist_wrt(sca_SndT_Fra$pos1, wrt = "beginnen")
}
