% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{standardize}
\alias{standardize}
\title{Age-standardized rates}
\usage{
standardize(x, label, standard_pop)
}
\arguments{
\item{x}{A fitted \code{surveil} model}

\item{label}{Labels (character strings) for the age groups that correspond to the values of \code{stand_pop}. All levels of the grouping variable used to fit the model (i.e., \code{names(x$data$cases)}) must be present in \code{label}.}

\item{standard_pop}{Standard population values corresponding to the age groups specified by \code{label}.}
}
\value{
A list, also of class "stand_surveil", containing the entire contents of the user-provided \code{surveil} model plus the following:
\describe{
\item{standard_summary}{summary data frame of standardized rates (means and 95 percent credible intervals)}

\item{standard_samples}{a data frame of Markov chain Monte Carlo (MCMC) samples from the posterior probability distribution for the standardized rates}

\item{standard_label}{user-provided age-group labels}

\item{standard_pop}{user-provided standardized population sizes (ordered as \code{standard_label})}
}
}
\description{
Convert \code{surveil} model results to age standardized rates using a fixed age distribution
}
\examples{
data(cancer)
data(standard)

head(standard)
head(cancer)

cancer2 <- subset(cancer, grepl("55-59|60-64|65-69", Age))
fit <- stan_rw(cancer2, time = Year, group = Age,
              chains = 2, iter = 1e3) # for speed only

stands <- standardize(fit,
                      label = standard$age,
                      standard_pop = standard$standard_pop)
print(stands)
plot(stands, style = "lines")

}
\seealso{
\code{vignette("age-standardization", package = "surveil")} \code{\link[surveil]{stan_rw}}  \code{\link[surveil]{plot.stand_surveil}} \code{\link[surveil]{print.stand_surveil}}
}
