# stri_trans_list: List Available Text Transforms and Transliterators

## Description

Returns a list of available text transform identifiers. Each of them may be used in [`stri_trans_general`](stri_trans_general.md) tasks.

## Usage

``` r
stri_trans_list()
```

## Value

Returns a character vector.

## Author(s)

[Marek Gagolewski](https://www.gagolewski.com/) and other contributors

## References

*General Transforms* -- ICU User Guide, <https://unicode-org.github.io/icu/userguide/transforms/general/>

## See Also

The official online manual of <span class="pkg">stringi</span> at <https://stringi.gagolewski.com/>

Gagolewski M., <span class="pkg">stringi</span>: Fast and portable character string processing in R, *Journal of Statistical Software* 103(2), 2022, 1-59, [doi:10.18637/jss.v103.i02](https://doi.org/10.18637/jss.v103.i02)

Other transform: [`stri_trans_char()`](stri_trans_char.md), [`stri_trans_general()`](stri_trans_general.md), [`stri_trans_nfc()`](stri_trans_nf.md), [`stri_trans_tolower()`](stri_trans_casemap.md)

## Examples




```r
stri_trans_list()
##   [1] "Accents-Any"                  "am_FONIPA-am"                
##   [3] "am-am_FONIPA"                 "am-am_Latn/BGN"              
##   [5] "am-ar"                        "am-chr"                      
##   [7] "am-fa"                        "Amharic-Latin/BGN"           
##   [9] "Any-Accents"                  "Any-am"                      
##  [11] "Any-am_FONIPA"                "Any-am_Latn/BGN"             
##  [13] "Any-Any"                      "Any-ar"                      
##  [15] "Any-ar_Latn/BGN"              "Any-Arab"                    
##  [17] "Any-Arabic"                   "Any-Armenian"                
##  [19] "Any-Armn"                     "Any-az/BGN"                  
##  [21] "Any-be_Latn/BGN"              "Any-Beng"                    
##  [23] "Any-Bengali"                  "Any-bg_Latn/BGN"             
##  [25] "Any-blt_FONIPA"               "Any-Bopo"                    
##  [27] "Any-Bopomofo"                 "Any-CanadianAboriginal"      
##  [29] "Any-Cans"                     "Any-ch_FONIPA"               
##  [31] "Any-chr"                      "Any-chr_FONIPA"              
##  [33] "Any-cs_FONIPA"                "Any-cy_FONIPA"               
##  [35] "Any-Cyrillic"                 "Any-Cyrl"                    
##  [37] "Any-Deva"                     "Any-Devanagari"              
##  [39] "Any-dsb_FONIPA"               "Any-dv_Latn/BGN"             
##  [41] "Any-el_Latn/BGN"              "Any-eo_FONIPA"               
##  [43] "Any-es_419_FONIPA"            "Any-es_FONIPA"               
##  [45] "Any-Ethi"                     "Any-Ethiopic"                
##  [47] "Any-fa"                       "Any-fa_FONIPA"               
##  [49] "Any-fa_Latn/BGN"              "Any-FCC"                     
##  [51] "Any-FCD"                      "Any-Geor"                    
##  [53] "Any-Georgian"                 "Any-Greek"                   
##  [55] "Any-Greek/UNGEGN"             "Any-Grek"                    
##  [57] "Any-Grek/UNGEGN"              "Any-Gujarati"                
##  [59] "Any-Gujr"                     "Any-Gurmukhi"                
##  [61] "Any-Guru"                     "Any-ha_NE"                   
##  [63] "Any-Hang"                     "Any-Hangul"                  
##  [65] "Any-Hans"                     "Any-Hant"                    
##  [67] "Any-he_Latn/BGN"              "Any-Hebr"                    
##  [69] "Any-Hebrew"                   "Any-Hex"                     
##  [71] "Any-Hex/C"                    "Any-Hex/Java"                
##  [73] "Any-Hex/Perl"                 "Any-Hex/Unicode"             
##  [75] "Any-Hex/XML"                  "Any-Hex/XML10"               
##  [77] "Any-Hira"                     "Any-Hiragana"                
##  [79] "Any-hy_AREVMDA_FONIPA"        "Any-hy_FONIPA"               
##  [81] "Any-hy_Latn/BGN"              "Any-ia_FONIPA"               
##  [83] "Any-Jamo"                     "Any-ka_Latn/BGN"             
##  [85] "Any-ka_Latn/BGN_1981"         "Any-Kana"                    
##  [87] "Any-Kannada"                  "Any-Katakana"                
##  [89] "Any-kk_FONIPA"                "Any-kk_Latn/BGN"             
##  [91] "Any-Knda"                     "Any-ky_FONIPA"               
##  [93] "Any-ky_Latn/BGN"              "Any-la_FONIPA"               
##  [95] "Any-Latin"                    "Any-Latn"                    
##  [97] "Any-Lower"                    "Any-Malayalam"               
##  [99] "Any-mk_Latn/BGN"              "Any-Mlym"                    
## [101] "Any-mn_Latn/BGN"              "Any-mn_Latn/MNS"             
## [103] "Any-my"                       "Any-my_FONIPA"               
## [105] "Any-my_Latn"                  "Any-Name"                    
## [107] "Any-NFC"                      "Any-NFD"                     
## [109] "Any-NFKC"                     "Any-NFKD"                    
## [111] "Any-Null"                     "Any-nv_FONIPA"               
## [113] "Any-Oriya"                    "Any-Orya"                    
## [115] "Any-pl_FONIPA"                "Any-ps_Latn/BGN"             
## [117] "Any-Publishing"               "Any-Remove"                  
## [119] "Any-rm_FONIPA_SURSILV"        "Any-ro_FONIPA"               
## [121] "Any-ru"                       "Any-ru_Latn/BGN"             
## [123] "Any-sat_FONIPA"               "Any-si_FONIPA"               
## [125] "Any-si_Latn"                  "Any-sk_FONIPA"               
## [127] "Any-sr_Latn/BGN"              "Any-Syrc"                    
## [129] "Any-Syriac"                   "Any-ta_FONIPA"               
## [131] "Any-Tamil"                    "Any-Taml"                    
## [133] "Any-Telu"                     "Any-Telugu"                  
## [135] "Any-Thaa"                     "Any-Thaana"                  
## [137] "Any-Thai"                     "Any-Title"                   
## [139] "Any-tk/BGN"                   "Any-ug_FONIPA"               
## [141] "Any-uk_Latn/BGN"              "Any-und_FONIPA"              
## [143] "Any-und_FONXSAMP"             "Any-Upper"                   
## [145] "Any-ur"                       "Any-uz_Cyrl"                 
## [147] "Any-uz_Latn"                  "Any-uz/BGN"                  
## [149] "Any-vec_FONIPA"               "Any-xh_FONIPA"               
## [151] "Any-yo_BJ"                    "Any-zh"                      
## [153] "Any-zu_FONIPA"                "ar-ar_Latn/BGN"              
## [155] "Arab-Latn"                    "Arabic-Latin"                
## [157] "Arabic-Latin/BGN"             "Armenian-Latin"              
## [159] "Armenian-Latin/BGN"           "Armn-Latn"                   
## [161] "ASCII-Latin"                  "az_Cyrl-az/BGN"              
## [163] "az-Lower"                     "az-Title"                    
## [165] "az-Upper"                     "Azerbaijani-Latin/BGN"       
## [167] "be-be_Latn/BGN"               "Belarusian-Latin/BGN"        
## [169] "Beng-Arab"                    "Beng-Deva"                   
## [171] "Beng-Gujr"                    "Beng-Guru"                   
## [173] "Beng-Knda"                    "Beng-Latn"                   
## [175] "Beng-Mlym"                    "Beng-Orya"                   
## [177] "Beng-Taml"                    "Beng-Telu"                   
## [179] "Beng-ur"                      "Bengali-Arabic"              
## [181] "Bengali-Devanagari"           "Bengali-Gujarati"            
## [183] "Bengali-Gurmukhi"             "Bengali-Kannada"             
## [185] "Bengali-Latin"                "Bengali-Malayalam"           
## [187] "Bengali-Oriya"                "Bengali-Tamil"               
## [189] "Bengali-Telugu"               "bg-bg_Latn/BGN"              
## [191] "blt-blt_FONIPA"               "Bopo-Latn"                   
## [193] "Bopomofo-Latin"               "Bulgarian-Latin/BGN"         
## [195] "Burmese-Latin"                "CanadianAboriginal-Latin"    
## [197] "Cans-Latn"                    "ch-am"                       
## [199] "ch-ar"                        "ch-ch_FONIPA"                
## [201] "ch-chr"                       "ch-fa"                       
## [203] "chr-chr_FONIPA"               "cs_FONIPA-ja"                
## [205] "cs_FONIPA-ko"                 "cs-am"                       
## [207] "cs-ar"                        "cs-chr"                      
## [209] "cs-cs_FONIPA"                 "cs-fa"                       
## [211] "cs-ja"                        "cs-ko"                       
## [213] "cy-cy_FONIPA"                 "Cyrillic-Latin"              
## [215] "Cyrl-Latn"                    "de-ASCII"                    
## [217] "Deva-Arab"                    "Deva-Beng"                   
## [219] "Deva-Gujr"                    "Deva-Guru"                   
## [221] "Deva-Knda"                    "Deva-Latn"                   
## [223] "Deva-Mlym"                    "Deva-Orya"                   
## [225] "Deva-Taml"                    "Deva-Telu"                   
## [227] "Deva-ur"                      "Devanagari-Arabic"           
## [229] "Devanagari-Bengali"           "Devanagari-Gujarati"         
## [231] "Devanagari-Gurmukhi"          "Devanagari-Kannada"          
## [233] "Devanagari-Latin"             "Devanagari-Malayalam"        
## [235] "Devanagari-Oriya"             "Devanagari-Tamil"            
## [237] "Devanagari-Telugu"            "Digit-Tone"                  
## [239] "dsb-dsb_FONIPA"               "dv-dv_Latn/BGN"              
## [241] "el-el_Latn/BGN"               "el-Lower"                    
## [243] "el-Title"                     "el-Upper"                    
## [245] "eo-am"                        "eo-ar"                       
## [247] "eo-chr"                       "eo-eo_FONIPA"                
## [249] "eo-fa"                        "es_419-am"                   
## [251] "es_419-ar"                    "es_419-chr"                  
## [253] "es_419-fa"                    "es_419-ja"                   
## [255] "es_419-zh"                    "es_FONIPA-am"                
## [257] "es_FONIPA-es_419_FONIPA"      "es_FONIPA-ja"                
## [259] "es_FONIPA-zh"                 "es-am"                       
## [261] "es-ar"                        "es-chr"                      
## [263] "es-es_FONIPA"                 "es-fa"                       
## [265] "es-ja"                        "es-zh"                       
## [267] "Ethi-Latn"                    "Ethiopic-Latin"              
## [269] "fa-fa_FONIPA"                 "fa-fa_Latn/BGN"              
## [271] "Fullwidth-Halfwidth"          "Geor-Latn"                   
## [273] "Georgian-Latin"               "Georgian-Latin/BGN"          
## [275] "Greek-Latin"                  "Greek-Latin/BGN"             
## [277] "Greek-Latin/UNGEGN"           "Grek-Latn"                   
## [279] "Grek-Latn/UNGEGN"             "Gujarati-Arabic"             
## [281] "Gujarati-Bengali"             "Gujarati-Devanagari"         
## [283] "Gujarati-Gurmukhi"            "Gujarati-Kannada"            
## [285] "Gujarati-Latin"               "Gujarati-Malayalam"          
## [287] "Gujarati-Oriya"               "Gujarati-Tamil"              
## [289] "Gujarati-Telugu"              "Gujr-Arab"                   
## [291] "Gujr-Beng"                    "Gujr-Deva"                   
## [293] "Gujr-Guru"                    "Gujr-Knda"                   
## [295] "Gujr-Latn"                    "Gujr-Mlym"                   
## [297] "Gujr-Orya"                    "Gujr-Taml"                   
## [299] "Gujr-Telu"                    "Gujr-ur"                     
## [301] "Gurmukhi-Arabic"              "Gurmukhi-Bengali"            
## [303] "Gurmukhi-Devanagari"          "Gurmukhi-Gujarati"           
## [305] "Gurmukhi-Kannada"             "Gurmukhi-Latin"              
## [307] "Gurmukhi-Malayalam"           "Gurmukhi-Oriya"              
## [309] "Gurmukhi-Tamil"               "Gurmukhi-Telugu"             
## [311] "Guru-Arab"                    "Guru-Beng"                   
## [313] "Guru-Deva"                    "Guru-Gujr"                   
## [315] "Guru-Knda"                    "Guru-Latn"                   
## [317] "Guru-Mlym"                    "Guru-Orya"                   
## [319] "Guru-Taml"                    "Guru-Telu"                   
## [321] "Guru-ur"                      "ha-ha_NE"                    
## [323] "Halfwidth-Fullwidth"          "Han-Latin"                   
## [325] "Han-Latin/Names"              "Hang-Latn"                   
## [327] "Hangul-Latin"                 "Hani-Latn"                   
## [329] "Hans-Hant"                    "Hant-Hans"                   
## [331] "he-he_Latn/BGN"               "Hebr-Latn"                   
## [333] "Hebrew-Latin"                 "Hebrew-Latin/BGN"            
## [335] "Hex-Any"                      "Hex-Any/C"                   
## [337] "Hex-Any/Java"                 "Hex-Any/Perl"                
## [339] "Hex-Any/Unicode"              "Hex-Any/XML"                 
## [341] "Hex-Any/XML10"                "Hira-Kana"                   
## [343] "Hira-Latn"                    "Hiragana-Katakana"           
## [345] "Hiragana-Latin"               "hy_AREVMDA-am"               
## [347] "hy_AREVMDA-ar"                "hy_AREVMDA-chr"              
## [349] "hy_AREVMDA-fa"                "hy_AREVMDA-hy_AREVMDA_FONIPA"
## [351] "hy-am"                        "hy-ar"                       
## [353] "hy-chr"                       "hy-fa"                       
## [355] "hy-hy_FONIPA"                 "hy-hy_Latn/BGN"              
## [357] "ia-am"                        "ia-ar"                       
## [359] "ia-chr"                       "ia-fa"                       
## [361] "ia-ia_FONIPA"                 "IPA-XSampa"                  
## [363] "it-am"                        "it-ja"                       
## [365] "ja_Hrkt-ja_Latn/BGN"          "ja_Latn-ko"                  
## [367] "ja_Latn-ru"                   "Jamo-Latin"                  
## [369] "Jamo-Latn"                    "ka-ka_Latn/BGN"              
## [371] "ka-ka_Latn/BGN_1981"          "Kana-Hira"                   
## [373] "Kana-Latn"                    "Kannada-Arabic"              
## [375] "Kannada-Bengali"              "Kannada-Devanagari"          
## [377] "Kannada-Gujarati"             "Kannada-Gurmukhi"            
## [379] "Kannada-Latin"                "Kannada-Malayalam"           
## [381] "Kannada-Oriya"                "Kannada-Tamil"               
## [383] "Kannada-Telugu"               "Katakana-Hiragana"           
## [385] "Katakana-Latin"               "Katakana-Latin/BGN"          
## [387] "Kazakh-Latin/BGN"             "Kirghiz-Latin/BGN"           
## [389] "kk-am"                        "kk-ar"                       
## [391] "kk-chr"                       "kk-fa"                       
## [393] "kk-kk_FONIPA"                 "kk-kk_Latn/BGN"              
## [395] "Knda-Arab"                    "Knda-Beng"                   
## [397] "Knda-Deva"                    "Knda-Gujr"                   
## [399] "Knda-Guru"                    "Knda-Latn"                   
## [401] "Knda-Mlym"                    "Knda-Orya"                   
## [403] "Knda-Taml"                    "Knda-Telu"                   
## [405] "Knda-ur"                      "ko-ko_Latn/BGN"              
## [407] "Korean-Latin/BGN"             "ky-am"                       
## [409] "ky-ar"                        "ky-chr"                      
## [411] "ky-fa"                        "ky-ky_FONIPA"                
## [413] "ky-ky_Latn/BGN"               "la-la_FONIPA"                
## [415] "Latin-Arabic"                 "Latin-Armenian"              
## [417] "Latin-ASCII"                  "Latin-Bengali"               
## [419] "Latin-Bopomofo"               "Latin-CanadianAboriginal"    
## [421] "Latin-Cyrillic"               "Latin-Devanagari"            
## [423] "Latin-Ethiopic"               "Latin-Georgian"              
## [425] "Latin-Greek"                  "Latin-Greek/UNGEGN"          
## [427] "Latin-Gujarati"               "Latin-Gurmukhi"              
## [429] "Latin-Hangul"                 "Latin-Hebrew"                
## [431] "Latin-Hiragana"               "Latin-Jamo"                  
## [433] "Latin-Kannada"                "Latin-Katakana"              
## [435] "Latin-Malayalam"              "Latin-NumericPinyin"         
## [437] "Latin-Oriya"                  "Latin-Russian/BGN"           
## [439] "Latin-Syriac"                 "Latin-Tamil"                 
## [441] "Latin-Telugu"                 "Latin-Thaana"                
## [443] "Latin-Thai"                   "Latn-Arab"                   
## [445] "Latn-Armn"                    "Latn-Beng"                   
## [447] "Latn-Bopo"                    "Latn-Cans"                   
## [449] "Latn-Cyrl"                    "Latn-Deva"                   
## [451] "Latn-Ethi"                    "Latn-Geor"                   
## [453] "Latn-Grek"                    "Latn-Grek/UNGEGN"            
## [455] "Latn-Gujr"                    "Latn-Guru"                   
## [457] "Latn-Hang"                    "Latn-Hebr"                   
## [459] "Latn-Hira"                    "Latn-Jamo"                   
## [461] "Latn-Kana"                    "Latn-Knda"                   
## [463] "Latn-Mlym"                    "Latn-Orya"                   
## [465] "Latn-Syrc"                    "Latn-Taml"                   
## [467] "Latn-Telu"                    "Latn-Thaa"                   
## [469] "Latn-Thai"                    "lt-Lower"                    
## [471] "lt-Title"                     "lt-Upper"                    
## [473] "Macedonian-Latin/BGN"         "Malayalam-Arabic"            
## [475] "Malayalam-Bengali"            "Malayalam-Devanagari"        
## [477] "Malayalam-Gujarati"           "Malayalam-Gurmukhi"          
## [479] "Malayalam-Kannada"            "Malayalam-Latin"             
## [481] "Malayalam-Oriya"              "Malayalam-Tamil"             
## [483] "Malayalam-Telugu"             "Maldivian-Latin/BGN"         
## [485] "mk-mk_Latn/BGN"               "Mlym-Arab"                   
## [487] "Mlym-Beng"                    "Mlym-Deva"                   
## [489] "Mlym-Gujr"                    "Mlym-Guru"                   
## [491] "Mlym-Knda"                    "Mlym-Latn"                   
## [493] "Mlym-Orya"                    "Mlym-Taml"                   
## [495] "Mlym-Telu"                    "Mlym-ur"                     
## [497] "mn-mn_Latn/BGN"               "mn-mn_Latn/MNS"              
## [499] "Mongolian-Latin/BGN"          "my-am"                       
## [501] "my-ar"                        "my-chr"                      
## [503] "my-fa"                        "my-my_FONIPA"                
## [505] "my-my_Latn"                   "my-Zawgyi"                   
## [507] "Myanmar-Latin"                "Name-Any"                    
## [509] "nl-Title"                     "NumericPinyin-Latin"         
## [511] "NumericPinyin-Pinyin"         "nv-nv_FONIPA"                
## [513] "Oriya-Arabic"                 "Oriya-Bengali"               
## [515] "Oriya-Devanagari"             "Oriya-Gujarati"              
## [517] "Oriya-Gurmukhi"               "Oriya-Kannada"               
## [519] "Oriya-Latin"                  "Oriya-Malayalam"             
## [521] "Oriya-Tamil"                  "Oriya-Telugu"                
## [523] "Orya-Arab"                    "Orya-Beng"                   
## [525] "Orya-Deva"                    "Orya-Gujr"                   
## [527] "Orya-Guru"                    "Orya-Knda"                   
## [529] "Orya-Latn"                    "Orya-Mlym"                   
## [531] "Orya-Taml"                    "Orya-Telu"                   
## [533] "Orya-ur"                      "Pashto-Latin/BGN"            
## [535] "Persian-Latin/BGN"            "Pinyin-NumericPinyin"        
## [537] "pl_FONIPA-ja"                 "pl-am"                       
## [539] "pl-ar"                        "pl-chr"                      
## [541] "pl-fa"                        "pl-ja"                       
## [543] "pl-pl_FONIPA"                 "ps-ps_Latn/BGN"              
## [545] "Publishing-Any"               "rm_SURSILV-am"               
## [547] "rm_SURSILV-ar"                "rm_SURSILV-chr"              
## [549] "rm_SURSILV-fa"                "rm_SURSILV-rm_FONIPA_SURSILV"
## [551] "ro_FONIPA-ja"                 "ro-am"                       
## [553] "ro-ar"                        "ro-chr"                      
## [555] "ro-fa"                        "ro-ja"                       
## [557] "ro-ro_FONIPA"                 "ru_Latn-ru/BGN"              
## [559] "ru-ja"                        "ru-ru_Latn/BGN"              
## [561] "ru-zh"                        "Russian-Latin/BGN"           
## [563] "sat_Olck-sat_FONIPA"          "sat-am"                      
## [565] "sat-ar"                       "sat-chr"                     
## [567] "sat-fa"                       "Serbian-Latin/BGN"           
## [569] "si-am"                        "si-ar"                       
## [571] "si-chr"                       "si-fa"                       
## [573] "si-si_FONIPA"                 "si-si_Latn"                  
## [575] "Simplified-Traditional"       "sk_FONIPA-ja"                
## [577] "sk-am"                        "sk-ar"                       
## [579] "sk-chr"                       "sk-fa"                       
## [581] "sk-ja"                        "sk-sk_FONIPA"                
## [583] "sr-sr_Latn/BGN"               "Syrc-Latn"                   
## [585] "Syriac-Latin"                 "ta-ta_FONIPA"                
## [587] "Tamil-Arabic"                 "Tamil-Bengali"               
## [589] "Tamil-Devanagari"             "Tamil-Gujarati"              
## [591] "Tamil-Gurmukhi"               "Tamil-Kannada"               
## [593] "Tamil-Latin"                  "Tamil-Malayalam"             
## [595] "Tamil-Oriya"                  "Tamil-Telugu"                
## [597] "Taml-Arab"                    "Taml-Beng"                   
## [599] "Taml-Deva"                    "Taml-Gujr"                   
## [601] "Taml-Guru"                    "Taml-Knda"                   
## [603] "Taml-Latn"                    "Taml-Mlym"                   
## [605] "Taml-Orya"                    "Taml-Telu"                   
## [607] "Taml-ur"                      "Telu-Arab"                   
## [609] "Telu-Beng"                    "Telu-Deva"                   
## [611] "Telu-Gujr"                    "Telu-Guru"                   
## [613] "Telu-Knda"                    "Telu-Latn"                   
## [615] "Telu-Mlym"                    "Telu-Orya"                   
## [617] "Telu-Taml"                    "Telu-ur"                     
## [619] "Telugu-Arabic"                "Telugu-Bengali"              
## [621] "Telugu-Devanagari"            "Telugu-Gujarati"             
## [623] "Telugu-Gurmukhi"              "Telugu-Kannada"              
## [625] "Telugu-Latin"                 "Telugu-Malayalam"            
## [627] "Telugu-Oriya"                 "Telugu-Tamil"                
## [629] "Thaa-Latn"                    "Thaana-Latin"                
## [631] "Thai-Latin"                   "Thai-Latn"                   
## [633] "tk_Cyrl-tk/BGN"               "tlh-am"                      
## [635] "tlh-ar"                       "tlh-chr"                     
## [637] "tlh-fa"                       "tlh-tlh_FONIPA"              
## [639] "Tone-Digit"                   "tr-Lower"                    
## [641] "tr-Title"                     "tr-Upper"                    
## [643] "Traditional-Simplified"       "Turkmen-Latin/BGN"           
## [645] "ug-ug_FONIPA"                 "uk-uk_Latn/BGN"              
## [647] "Ukrainian-Latin/BGN"          "und_FONIPA-ar"               
## [649] "und_FONIPA-chr"               "und_FONIPA-fa"               
## [651] "und_FONIPA-und_FONXSAMP"      "und_FONXSAMP-und_FONIPA"     
## [653] "uz_Cyrl-uz_Latn"              "uz_Cyrl-uz/BGN"              
## [655] "uz_Latn-uz_Cyrl"              "Uzbek-Latin/BGN"             
## [657] "vec-vec_FONIPA"               "xh-am"                       
## [659] "xh-ar"                        "xh-chr"                      
## [661] "xh-fa"                        "xh-xh_FONIPA"                
## [663] "XSampa-IPA"                   "yo-yo_BJ"                    
## [665] "Zawgyi-my"                    "zh_Latn_PINYIN-ru"           
## [667] "zu-am"                        "zu-ar"                       
## [669] "zu-chr"                       "zu-fa"                       
## [671] "zu-zu_FONIPA"
```
