% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{test_driver}
\alias{test_driver}
\title{Test a storr driver}
\usage{
test_driver(create)
}
\arguments{
\item{create}{A function with one arguments that when run with
\code{NULL} as the argument will create a new driver instance.
It will also be called with a driver (of the same type) as an
argument - in this case, you must create a new driver object
pointing at the same underlying storage (see the examples).
Depending on your storage model, temporary directories,
in-memory locations, or random-but-unique prefixes may help
create isolated locations for the test (the tests assume that a
storr created with \code{create} is entirely empty).}
}
\description{
Test that a driver passes all storr tests.  This page is only of
interest to people developing storr drivers; nothing here is
required for using storr.
}
\details{
This will run through a suite of functions to test that a driver
is likely to behave itself.  As bugs are found they will be added
to the test suite to guard against regressions.

The test suite is included in the package as
\code{system.file("spec", package = "storr")}.

The procedure for each test block is:
\enumerate{
\item{Create a new driver by running \code{dr <- create()}.}
\item{Run a number of tests.}
\item{Destroy the driver by running \code{dr$destroy()}.}
}

So before running this test suite, make sure this will not harm
any precious data!
}
\examples{
## Testing the environment driver is nice and fast:
if (requireNamespace("testthat")) {
  create_env <- function(dr = NULL, ...) {
    driver_environment(dr$envir, ...)
  }
  test_driver(create_env)
}

# To test things like the rds driver, I would run:
\dontrun{
if (requireNamespace("testthat")) {
  create_rds <- function(dr = NULL) {
    driver_rds(if (is.null(dr)) tempfile() else dr$path)
  }
  test_driver(create_rds)
}
}
}
