% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{sv_constant}
\alias{sv_constant}
\alias{sv_normal}
\alias{sv_multinormal}
\alias{sv_gamma}
\alias{sv_inverse_gamma}
\alias{sv_beta}
\alias{sv_exponential}
\alias{sv_infinity}
\title{Prior Distributions in \code{stochvol}}
\usage{
sv_constant(value)

sv_normal(mean = 0, sd = 1)

sv_multinormal(mean = 0, precision = NULL, sd = 1, dim = NA)

sv_gamma(shape, rate)

sv_inverse_gamma(shape, scale)

sv_beta(shape1, shape2)

sv_exponential(rate)

sv_infinity()
}
\arguments{
\item{value}{The constant value for the degenerate constant distribution}

\item{mean}{Expected value for the univariate normal distribution or mean vector of the multivariate normal distribution}

\item{sd}{Standard deviation for the univariate normal distribution or constant scale of the multivariate normal distribution}

\item{precision}{Precision matrix for the multivariate normal distribution}

\item{dim}{(optional) Dimension of the multivariate distribution}

\item{shape}{Shape parameter for the distribution}

\item{rate}{Rate parameter for the distribution}

\item{scale}{Scale parameter for the distribution}

\item{shape1}{First shape parameter for the distribution}

\item{shape2}{Second shape parameter for the distribution}
}
\description{
The functions below can be supplied to \code{\link{specify_priors}}
to overwrite the default set of prior distributions in \code{\link{svsample}}.
The functions have \code{mean}, \code{range}, \code{density}, and
\code{print} methods.
}
\section{Multivariate Normal}{

Multivariate normal objects can be specified several ways. The most general way is by calling
\code{sv_multinormal(mean, precision)}, which allows for arbitrary mean and (valid) precision
arguments. Constant mean vectors and constant diagonal precision matrices of dimension \code{D}
can be created two ways: either \code{sv_multinormal(mean, sd, dim = D)} or
\code{rep(sv_normal(mean, sd), length.out = D)}.
}

\seealso{
Other priors: 
\code{\link{specify_priors}()}
}
\concept{priors}
