% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stm-package.R
\docType{data}
\name{gadarian}
\alias{gadarian}
\alias{gadarianFit}
\title{Gadarian and Albertson data}
\format{
A data frame with 351 observations on the following 3 variables.
\describe{ 
\item{\code{MetaID}}{A numeric vector containing identification
numbers; not used for analysis} 
\item{\code{treatment}}{A numeric vector
indicating treatment condition} 
\item{\code{pid_rep}}{A numeric vector of
party identification} 
\item{\code{open.ended.response}}{A character vector
of the subject's open ended response} 
}
}
\source{
Gadarian, Shana Kushner, and Bethany Albertson. "Anxiety,
immigration, and the search for information." Political Psychology 35.2
(2014): 133-164.

Roberts, Margaret E., Brandon M. Stewart, Dustin Tingley, Christopher Lucas,
Jetson Leder-Luis, Shana Kushner Gadarian, Bethany Albertson, and David G.
Rand.  "Structural Topic Models for Open-Ended Survey Responses." American
Journal of Political Science 58, no 4 (2014): 1064-1082.
}
\description{
This data set
contains variables from Gadarian and Albertson (2014). The experiment had
those in the treatment condition write about what made them anxious about
immigration. The control condition just had subjects write about
immigration.
}
\examples{
\donttest{

head(gadarian)
#Process the data for analysis.
temp<-textProcessor(documents=gadarian$open.ended.response,metadata=gadarian)
meta<-temp$meta
vocab<-temp$vocab
docs<-temp$documents
out <- prepDocuments(docs, vocab, meta)
docs<-out$documents
vocab<-out$vocab
meta <-out$meta
}
}
\keyword{datasets}
