% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.lc.gen.bs}
\alias{ci.lc.gen.bs}
\title{Confidence interval for a linear contrast of parameters in a between-subjects
design}
\usage{
ci.lc.gen.bs(alpha, est, se, v)
}
\arguments{
\item{alpha}{alpha level for simultaneous 1-alpha confidence}

\item{est}{vector of parameter estimates}

\item{se}{vector of standard errors}

\item{v}{vector of contrast coefficients}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimate of linear contrast
\item SE - standard error of linear contrast
\item LL - lower limit of confidence interval
\item UL - upper limit of confidence interval
}
}
\description{
Computes the estimate, standard error, and approximate confidence interval
for a linear contrast of any type of parameter (e.g., quartile, ordinal
regression slope, path coefficient, G-index) where each parameter value has
been estimated from a different sample. The parameter vaues are assumed to
be of the same type (e.g., all unstandardized path coefficients) and their
sampling distributions are assumed to be approximately normal.
}
\examples{
est <- c(3.86, 4.57, 2.29, 2.88)
se <- c(0.185, 0.365, 0.275, 0.148)
v <- c(.5, .5, -.5, -.5)
ci.lc.gen.bs(.05, est, se, v)

# Should return:
#      Estimate        SE       LL       UL
# [1,]     1.63 0.2573806 1.125543 2.134457


}
