% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIG_FC.R
\name{migfc}
\alias{migfc}
\title{A function to compute Mean information gain (MIG) and Fluctuation complexity (FC)}
\usage{
migfc(x, L)
}
\arguments{
\item{x}{A time series}

\item{L}{word length parameter}
}
\value{
A list containing MIG, FC and transition matrices.
}
\description{
Calculates MIG and FC
}
\details{
MIG and FC are based on a median partitioning of the time series
Following Hauhs, M. and Lange, H., 2008. Classification of runoff in headwater catchments: A physical problem?. Geography Compass, 2(1), pp.235-254.
ATTENTION: This function is still in development and needs further testing!
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^4)
migfc(x, L=4)
}
\references{
Hauhs, M. and Lange, H., (2008) Geography Compass, 2(1), pp.235-254.
}
\author{
Sebastian Sippel
}
