% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HVG.R
\name{HVG}
\alias{HVG}
\title{A function to compute Horizontal Visibility Graphs and associated statistics}
\usage{
HVG(x, meth, maxL, rho)
}
\arguments{
\item{x}{A time series}

\item{meth}{A character string that describes the HVG method to use. Currently implemented: "HVG", "HVG_weighted", "LPHVG", "LPHVG_weighted".}

\item{maxL}{Maximum length of the time series.}

\item{rho}{Additional parameter}
}
\value{
A list that contains the adjacency matrix, degree distribution, and further HVG-based statistics.
}
\description{
Calculates a Horizontal Visibility Graph
}
\details{
Horizontal Visibility Graphs map a time series into a complex network.
Following Luque, B., Lacasa, L., Ballesteros, F. and Luque, J., 2009. Horizontal visibility graphs: Exact results for random time series. Physical Review E, 80(4), p.046103.
ATTENTION: This function is still in development and needs further testing!
}
\examples{
x = arima.sim(model=list(ar = 0.3), n = 10^2)
HVG(x, meth = "HVG", maxL = 10^9, rho = NA)
}
\references{
Luque, B., Lacasa, L., Ballesteros, F. and Luque, J., 2009. Physical Review E, 80(4), p.046103.
}
\author{
Sebastian Sippel
}
