% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{weights.starnet}
\alias{weights.starnet}
\title{Extract Weights}
\usage{
\method{weights}{starnet}(object, ...)
}
\arguments{
\item{object}{\link[starnet]{starnet} object}

\item{...}{further arguments (not applicable)}
}
\value{
Vector containing intercept and slopes from the meta learner.
}
\description{
Extracts coefficients from the meta learner,
i.e. the weights for the base learners.
}
\examples{
\dontshow{
if(!grepl('SunOS',Sys.info()['sysname'])){
set.seed(1)
n <- 50; p <- 100
y <- rnorm(n=n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
object <- starnet(y=y,X=X)
weights(object)}}
\donttest{
set.seed(1)
n <- 50; p <- 100
y <- rnorm(n=n)
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
object <- starnet(y=y,X=X)
weights(object)}

}
